/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import org.apache.sis.measure.Angle;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.cs.DefaultAffineCS;
import org.apache.sis.referencing.cs.SubTypes;
import org.apache.sis.referencing.internal.Resources;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystemAxis;

@XmlType(name="CartesianCSType")
@XmlRootElement(name="CartesianCS")
public class DefaultCartesianCS
extends DefaultAffineCS
implements CartesianCS {
    private static final long serialVersionUID = -6182037957705712945L;

    public DefaultCartesianCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) {
        super(properties, axis0, axis1);
    }

    public DefaultCartesianCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) {
        super(properties, axis0, axis1, axis2);
    }

    private DefaultCartesianCS(DefaultCartesianCS original, String name, CoordinateSystemAxis[] axes) {
        super(original, name, axes);
    }

    protected DefaultCartesianCS(CartesianCS original) {
        super((AffineCS)original);
    }

    public static DefaultCartesianCS castOrCopy(CartesianCS object) {
        return object == null || object instanceof DefaultCartesianCS ? (DefaultCartesianCS)object : new DefaultCartesianCS(object);
    }

    @Override
    final void validate(Map<String, ?> properties) {
        super.validate(properties);
        int dimension = this.getDimension();
        for (int i = 0; i < dimension; ++i) {
            AxisDirection axis0 = this.getAxis(i).getDirection();
            int j = i;
            while (++j < dimension) {
                AxisDirection axis1 = this.getAxis(j).getDirection();
                Angle angle = CoordinateSystems.angle(axis0, axis1);
                if (angle == null || Math.abs(angle.degrees()) == 90.0) continue;
                throw new IllegalArgumentException(Resources.forProperties(properties).getString((short)56, axis0, axis1));
            }
        }
    }

    public Class<? extends CartesianCS> getInterface() {
        return CartesianCS.class;
    }

    @Override
    public DefaultCartesianCS forConvention(AxesConvention convention) {
        return (DefaultCartesianCS)super.forConvention(convention);
    }

    @Override
    final AbstractCS createForAxes(String name, CoordinateSystemAxis[] axes) {
        switch (axes.length) {
            case 1: {
                return SubTypes.createOneDimensional(this, name, axes);
            }
            case 2: 
            case 3: {
                return new DefaultCartesianCS(this, name, axes);
            }
        }
        throw DefaultCartesianCS.unexpectedDimension(axes, 1, 3);
    }

    private DefaultCartesianCS() {
    }
}

