/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

@XmlTransient
public class DefaultCompoundCS
extends AbstractCS {
    private static final long serialVersionUID = -5726410275278843373L;
    private final List<CoordinateSystem> components;

    public DefaultCompoundCS(Map<String, ?> properties, CoordinateSystem ... components) {
        components = DefaultCompoundCS.clone(components);
        super(properties, DefaultCompoundCS.getAxes(components));
        this.components = UnmodifiableArrayList.wrap((Object[])components);
    }

    private DefaultCompoundCS(DefaultCompoundCS original, CoordinateSystem[] components) {
        super(original, null, DefaultCompoundCS.getAxes(components));
        this.components = UnmodifiableArrayList.wrap((Object[])components);
    }

    public DefaultCompoundCS(CoordinateSystem ... components) {
        components = DefaultCompoundCS.clone(components);
        this(components, DefaultCompoundCS.getAxes(components));
    }

    private DefaultCompoundCS(CoordinateSystem[] components, CoordinateSystemAxis[] axes) {
        super(Map.of("name", AxisDirections.appendTo(new StringBuilder(60).append("Compound CS"), axes)), axes);
        this.components = UnmodifiableArrayList.wrap((Object[])components);
    }

    private static CoordinateSystem[] clone(CoordinateSystem[] components) {
        components = (CoordinateSystem[])components.clone();
        for (int i = 0; i < components.length; ++i) {
            ArgumentChecks.ensureNonNullElement((String)"components", (int)i, (Object)components[i]);
        }
        return components;
    }

    private static CoordinateSystemAxis[] getAxes(CoordinateSystem[] components) {
        int count = 0;
        for (int i = 0; i < components.length; ++i) {
            count += components[i].getDimension();
        }
        CoordinateSystemAxis[] axis = new CoordinateSystemAxis[count];
        count = 0;
        for (CoordinateSystem c : components) {
            int dim = c.getDimension();
            for (int j = 0; j < dim; ++j) {
                axis[count++] = c.getAxis(j);
            }
        }
        assert (count == axis.length);
        return axis;
    }

    public List<CoordinateSystem> getComponents() {
        return this.components;
    }

    @Override
    public DefaultCompoundCS forConvention(AxesConvention convention) {
        DefaultCompoundCS cs = (DefaultCompoundCS)this.getCached(Objects.requireNonNull(convention));
        if (cs == null) {
            cs = this;
            boolean changed = false;
            CoordinateSystem[] newComponents = new CoordinateSystem[this.components.size()];
            for (int i = 0; i < newComponents.length; ++i) {
                CoordinateSystem component = this.components.get(i);
                AbstractCS m = DefaultCompoundCS.castOrCopy(component);
                if (m != (m = m.forConvention(convention))) {
                    component = m;
                    changed = true;
                }
                newComponents[i] = component;
            }
            if (changed) {
                cs = new DefaultCompoundCS(cs, newComponents);
            }
            cs = (DefaultCompoundCS)this.setCached(convention, cs);
        }
        return cs;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (!(object instanceof DefaultCompoundCS) || !super.equals(object, mode)) {
            return false;
        }
        return Utilities.deepEquals(this.components, ((DefaultCompoundCS)object).components, (ComparisonMode)mode);
    }
}

