/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.time.temporal.Temporal;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.referencing.datum.DynamicReferenceFrame;
import org.apache.sis.referencing.internal.VerticalDatumTypes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Version;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.internal.shared.LegacyNamespaces;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;

@XmlType(name="VerticalDatumType")
@XmlRootElement(name="VerticalDatum")
public class DefaultVerticalDatum
extends AbstractDatum
implements VerticalDatum {
    private static final long serialVersionUID = 380347456670516572L;
    private VerticalDatumType type;

    public DefaultVerticalDatum(Map<String, ?> properties, VerticalDatumType type) {
        super(properties);
        this.type = Objects.requireNonNull(type);
    }

    protected DefaultVerticalDatum(VerticalDatum datum) {
        super((Datum)datum);
        this.type = datum.getVerticalDatumType();
    }

    public static DefaultVerticalDatum castOrCopy(VerticalDatum object) {
        return object == null || object instanceof DefaultVerticalDatum ? (DefaultVerticalDatum)object : new DefaultVerticalDatum(object);
    }

    public Class<? extends VerticalDatum> getInterface() {
        return VerticalDatum.class;
    }

    public VerticalDatumType getVerticalDatumType() {
        if (this.type == null) {
            return VerticalDatumTypes.fromDatum(super.getName().getCode(), super.getAlias(), null);
        }
        return this.type;
    }

    private VerticalDatumType getOrGuessMethod(FormattableObject parent) {
        if (this.type != null && this.type != VerticalDatumType.OTHER_SURFACE) {
            return this.type;
        }
        CoordinateSystemAxis axis = null;
        if (parent instanceof CoordinateReferenceSystem) {
            axis = ((CoordinateReferenceSystem)parent).getCoordinateSystem().getAxis(0);
        }
        return VerticalDatumTypes.fromDatum(this.getName().getCode(), this.getAlias(), axis);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                DefaultVerticalDatum other = (DefaultVerticalDatum)object;
                return Objects.equals(this.type, other.type);
            }
            case BY_CONTRACT: {
                VerticalDatum other = (VerticalDatum)object;
                return Objects.equals(this.getVerticalDatumType(), other.getVerticalDatumType());
            }
        }
        return true;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hashCode(this.type);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        String name = super.formatTo(formatter);
        if (name != null) {
            return name;
        }
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.append(VerticalDatumTypes.toLegacyCode(this.getOrGuessMethod(formatter.getEnclosingElement(1))));
            return "Vert_Datum";
        }
        return formatter.shortOrLong("VDatum", "VerticalDatum");
    }

    private DefaultVerticalDatum() {
    }

    @XmlElement(name="verticalDatumType")
    private VerticalDatumType getTypeElement() {
        if (Context.isGMLVersion((Context)Context.current(), (Version)LegacyNamespaces.VERSION_3_2)) {
            return null;
        }
        return this.getOrGuessMethod(null);
    }

    private void setTypeElement(VerticalDatumType t) {
        if (this.type == null) {
            this.type = t;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultVerticalDatum.class, (String)"setTypeElement", (String)"verticalDatumType");
        }
    }

    public static class Dynamic
    extends DefaultVerticalDatum
    implements DynamicReferenceFrame {
        private static final long serialVersionUID = -2047994195060747008L;
        private final Temporal frameReferenceEpoch;

        public Dynamic(Map<String, ?> properties, VerticalDatumType type, Temporal epoch) {
            super(properties, type);
            this.frameReferenceEpoch = Objects.requireNonNull(epoch);
        }

        protected Dynamic(VerticalDatum datum) {
            super(datum);
            this.frameReferenceEpoch = Objects.requireNonNull(((DynamicReferenceFrame)datum).getFrameReferenceEpoch());
        }

        @Override
        public Temporal getFrameReferenceEpoch() {
            return this.frameReferenceEpoch;
        }

        @Override
        public boolean equals(Object object, ComparisonMode mode) {
            return super.equals(object, mode) && (mode != ComparisonMode.STRICT || this.frameReferenceEpoch.equals(((Dynamic)object).frameReferenceEpoch));
        }

        @Override
        protected long computeHashCode() {
            return super.computeHashCode() + (long)(31 * this.frameReferenceEpoch.hashCode());
        }
    }
}

