/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Map;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.provider.FormulaCategory;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.SingleOperation;

@XmlTransient
public abstract class AbstractProvider
extends DefaultOperationMethod
implements MathTransformProvider {
    private static final long serialVersionUID = -5087102598171128284L;
    public static final Logger LOGGER = Logger.getLogger("org.apache.sis.referencing.factory");
    private final Class<? extends SingleOperation> operationType;
    public final Class<? extends CoordinateSystem> sourceCSType;
    public final Class<? extends CoordinateSystem> targetCSType;
    public final boolean sourceOnEllipsoid;
    public final boolean targetOnEllipsoid;
    public final byte minSourceDimension;

    AbstractProvider(Class<? extends SingleOperation> operationType, ParameterDescriptorGroup parameters, Class<? extends CoordinateSystem> sourceCSType, boolean sourceOnEllipsoid, Class<? extends CoordinateSystem> targetCSType, boolean targetOnEllipsoid, byte minSourceDimension) {
        super(IdentifiedObjects.getProperties((IdentifiedObject)parameters, new String[0]), parameters);
        this.operationType = operationType;
        this.sourceCSType = sourceCSType;
        this.targetCSType = targetCSType;
        this.sourceOnEllipsoid = sourceOnEllipsoid;
        this.targetOnEllipsoid = targetOnEllipsoid;
        this.minSourceDimension = minSourceDimension;
    }

    static ParameterBuilder builder() {
        return ((ParameterBuilder)new ParameterBuilder().setCodeSpace((Citation)Citations.EPSG, "EPSG")).setRequired(true);
    }

    static ParameterBuilder addNameAndLegacy(ParameterBuilder builder, String name, String legacy) {
        return (ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addName(name)).setDeprecated(true)).setRemarks((CharSequence)Vocabulary.formatInternational((short)190, (Object)name))).addName(legacy)).setDeprecated(false)).setRemarks(null);
    }

    static ParameterBuilder addIdentifierAndLegacy(ParameterBuilder builder, String code, String legacy) {
        return (ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier(code)).setDeprecated(true)).setRemarks((CharSequence)Vocabulary.formatInternational((short)190, (Object)code))).addIdentifier(legacy)).setDeprecated(false)).setRemarks(null);
    }

    static ParameterDescriptor<Double> createZeroConstant(ParameterBuilder builder) {
        Double zero = 0.0;
        return builder.createBounded(MeasurementRange.create((double)-0.0, (boolean)true, (double)zero, (boolean)true, (Unit)Units.DEGREE), zero);
    }

    static ParameterDescriptor<Double> createMandatoryLatitude(ParameterBuilder builder) {
        return builder.createBounded(-90.0, 90.0, Double.NaN, Units.DEGREE);
    }

    static ParameterDescriptor<Double> createLatitude(ParameterBuilder builder, boolean includePoles) {
        return builder.createBounded(MeasurementRange.create((double)-90.0, (boolean)includePoles, (double)90.0, (boolean)includePoles, (Unit)Units.DEGREE), 0.0);
    }

    static ParameterDescriptor<Double> createLongitude(ParameterBuilder builder) {
        return builder.createBounded(-180.0, 180.0, 0.0, Units.DEGREE);
    }

    static ParameterDescriptor<Double> createScale(ParameterBuilder builder) {
        return builder.createStrictlyPositive(1.0, Units.UNITY);
    }

    static ParameterDescriptor<Double> createShift(ParameterBuilder builder) {
        return builder.create(0.0, Units.METRE);
    }

    static Ellipsoid getEllipsoid(String name, Parameters values, ParameterDescriptor<Double> semiMajor, ParameterDescriptor<Double> semiMinor) {
        ParameterValue<Double> p = values.getOrCreate(semiMajor);
        Unit unit = p.getUnit().asType(Length.class);
        double a = p.doubleValue();
        double b = values.doubleValue(semiMinor, unit);
        return DefaultEllipsoid.createEllipsoid(Map.of("name", name), a, b, (Unit<Length>)unit);
    }

    @Override
    public final Class<? extends SingleOperation> getOperationType() {
        return this.operationType;
    }

    public String resolveAmbiguity(MathTransformProvider.Context context) {
        return null;
    }

    public AbstractProvider variantFor(MathTransform transform) {
        return this;
    }

    public FormulaCategory getFormulaCategory() {
        return FormulaCategory.ASSUME_NORMALIZED_CRS;
    }

    public AbstractProvider inverse() {
        return null;
    }

    static int maxDimension(MathTransform transform) {
        return Math.max(transform.getSourceDimensions(), transform.getTargetDimensions());
    }

    static void recoverableException(Class<? extends AbstractProvider> caller, Exception e) {
        Logging.recoverableException((Logger)LOGGER, caller, (String)"createMathTransform", (Throwable)e);
    }
}

