/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.GeographicToGeocentric;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

public final class GeocentricToGeographic
extends AbstractProvider {
    private static final long serialVersionUID = 8459294628751497567L;
    public static final String NAME = "Geocentric_To_Ellipsoid";
    public static final ParameterDescriptorGroup PARAMETERS = ((ParameterBuilder)GeocentricToGeographic.builder().addName((Citation)Citations.OGC, "Geocentric_To_Ellipsoid")).createGroupForMapProjection(new ParameterDescriptor[0]);

    public GeocentricToGeographic() {
        super(Conversion.class, PARAMETERS, CartesianCS.class, false, EllipsoidalCS.class, true, (byte)3);
    }

    @Override
    public MathTransform createMathTransform(MathTransformProvider.Context context) throws FactoryException {
        MathTransform tr = GeographicToGeocentric.create(context, context.getTargetDimensions(), context.getSourceCSType());
        try {
            tr = tr.inverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new FactoryException((Throwable)e);
        }
        return tr;
    }
}

