/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.measure.Unit;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

@XmlTransient
public abstract class MapProjection
extends AbstractProvider {
    private static final long serialVersionUID = -601413094691431910L;
    public static final DefaultParameterDescriptor<Double> SEMI_MAJOR;
    public static final DefaultParameterDescriptor<Double> SEMI_MINOR;
    public static final DefaultParameterDescriptor<Double> ECCENTRICITY;

    protected MapProjection(ParameterDescriptorGroup parameters) {
        super(Conversion.class, parameters, EllipsoidalCS.class, true, CartesianCS.class, false, (byte)2);
    }

    public MapProjection sourceOfPseudo() {
        return this;
    }

    public static void validate(ParameterDescriptor<? extends Number> descriptor, double value) throws IllegalArgumentException {
        double maxValue;
        if (!Double.isFinite(value)) {
            throw new IllegalArgumentException(Resources.format((short)25, descriptor.getName(), value));
        }
        Comparable min = descriptor.getMinimumValue();
        Comparable max = descriptor.getMaximumValue();
        double minValue = min instanceof Number ? ((Number)((Object)min)).doubleValue() : Double.NaN;
        double d = maxValue = max instanceof Number ? ((Number)((Object)max)).doubleValue() : Double.NaN;
        if ((value < minValue || value > maxValue) && minValue != maxValue) {
            throw new IllegalArgumentException(Errors.format((short)204, (Object)descriptor.getName(), (Object)min, (Object)max, (Object)value));
        }
    }

    public static Ellipsoid getEllipsoid(Parameters values, MathTransformProvider.Context context) {
        Ellipsoid c;
        if (context instanceof DefaultMathTransformFactory.Context && (c = ((DefaultMathTransformFactory.Context)context).getSourceEllipsoid()) != null) {
            return c;
        }
        return MapProjection.getEllipsoid("source", values, SEMI_MAJOR, SEMI_MINOR);
    }

    @Override
    public final MathTransform createMathTransform(MathTransformProvider.Context context) throws FactoryException {
        return MapProjection.maybe3D(context, this.createProjection(Parameters.castOrWrap(context.getCompletedParameters())).createMapProjection(context));
    }

    static MathTransform maybe3D(MathTransformProvider.Context context, MathTransform mt) throws FactoryException {
        if (context.getTargetDimensions().orElse(2) >= 3) {
            mt = context.getFactory().createPassThroughTransform(0, mt, 1);
        }
        return mt;
    }

    protected abstract NormalizedProjection createProjection(Parameters var1);

    private static GenericName sameNameAs(Citation authority, GeneralParameterDescriptor parameters) {
        for (GenericName candidate : parameters.getAlias()) {
            if (!(candidate instanceof Identifier) || ((Identifier)candidate).getAuthority() != authority) continue;
            return candidate;
        }
        throw new NoSuchElementException();
    }

    static ParameterBuilder renameAlias(ParameterBuilder builder, ParameterDescriptor<Double> template, Citation toRename, ParameterDescriptor<Double> replacement) {
        MapProjection.renameAliases(builder, template, new Citation[]{toRename}, new ParameterDescriptor[]{replacement});
        return builder;
    }

    static ParameterBuilder renameAlias(ParameterBuilder builder, ParameterDescriptor<Double> template, Citation s1, ParameterDescriptor<Double> r1, Citation s2, ParameterDescriptor<Double> r2) {
        MapProjection.renameAliases(builder, template, new Citation[]{s1, s2}, new ParameterDescriptor[]{r1, r2});
        return builder;
    }

    private static void renameAliases(ParameterBuilder builder, ParameterDescriptor<Double> template, Citation[] toRename, ParameterDescriptor<?>[] replacement) {
        int i;
        Citation authority;
        builder.addName(template.getName());
        GenericName[] newNames = new GenericName[toRename.length];
        Identifier[] newCodes = new Identifier[toRename.length];
        for (int i2 = 0; i2 < toRename.length; ++i2) {
            newNames[i2] = MapProjection.sameNameAs(toRename[i2], replacement[i2]);
            newCodes[i2] = IdentifiedObjects.getIdentifier(replacement[i2], toRename[i2]);
        }
        for (GenericName alias : template.getAlias()) {
            if (alias instanceof Identifier) {
                authority = ((Identifier)alias).getAuthority();
                for (i = 0; i < toRename.length; ++i) {
                    if (authority != toRename[i] || newNames[i] == null) continue;
                    alias = newNames[i];
                    newNames[i] = null;
                    break;
                }
            }
            builder.addName(alias);
        }
        for (ReferenceIdentifier id : template.getIdentifiers()) {
            authority = id.getAuthority();
            for (i = 0; i < toRename.length; ++i) {
                if (authority != toRename[i] || newCodes[i] == null) continue;
                id = (ReferenceIdentifier)newCodes[i];
                newCodes[i] = null;
                break;
            }
            builder.addIdentifier(id);
        }
    }

    static InternationalString notFormalParameter(String origin) {
        return Resources.formatInternational((short)60, (Object)origin);
    }

    static {
        MeasurementRange valueDomain = MeasurementRange.createGreaterThan((double)0.0, (Unit)Units.METRE);
        GenericName[] aliases = new GenericName[]{new NamedIdentifier((Citation)Citations.ESRI, "Semi_Major"), new NamedIdentifier((Citation)Citations.NETCDF, "semi_major_axis"), new NamedIdentifier((Citation)Citations.GEOTIFF, "SemiMajorAxis"), new NamedIdentifier((Citation)Citations.PROJ4, "a")};
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("authority", Citations.OGC);
        properties.put("name", "semi_major");
        properties.put("alias", aliases);
        properties.put("identifiers", new ImmutableIdentifier((Citation)Citations.GEOTIFF, null, "2057"));
        SEMI_MAJOR = new DefaultParameterDescriptor<Object>((Map<String, ?>)properties, 1, 1, (Class<Object>)Double.class, (Range<?>)valueDomain, null, null);
        properties.put("name", "semi_minor");
        aliases[0] = new NamedIdentifier((Citation)Citations.ESRI, "Semi_Minor");
        aliases[1] = new NamedIdentifier((Citation)Citations.NETCDF, "semi_minor_axis");
        aliases[2] = new NamedIdentifier((Citation)Citations.GEOTIFF, "SemiMinorAxis");
        aliases[3] = new NamedIdentifier((Citation)Citations.PROJ4, "b");
        properties.put("identifiers", new ImmutableIdentifier((Citation)Citations.GEOTIFF, null, "2058"));
        SEMI_MINOR = new DefaultParameterDescriptor<Object>((Map<String, ?>)properties, 1, 1, (Class<Object>)Double.class, (Range<?>)valueDomain, null, null);
        properties.clear();
        properties.put("authority", Citations.SIS);
        properties.put("name", "eccentricity");
        ECCENTRICITY = new DefaultParameterDescriptor<Object>((Map<String, ?>)properties, 1, 1, (Class<Object>)Double.class, (Range<?>)MeasurementRange.create((double)0.0, (boolean)true, (double)1.0, (boolean)true, null), null, null);
    }
}

