/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.measure.UnitConverter;
import org.apache.sis.referencing.internal.shared.AffineTransform2D;
import org.apache.sis.referencing.internal.shared.DirectPositionView;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.CopyTransform;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.DomainDefinition;
import org.apache.sis.referencing.operation.transform.IdentityTransform;
import org.apache.sis.referencing.operation.transform.LinearInterpolator1D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform1D;
import org.apache.sis.referencing.operation.transform.OnewayLinearTransform;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.referencing.operation.transform.ProjectiveTransform;
import org.apache.sis.referencing.operation.transform.ProjectiveTransform2D;
import org.apache.sis.referencing.operation.transform.ScaleTransform;
import org.apache.sis.referencing.operation.transform.SpecializableTransform;
import org.apache.sis.referencing.operation.transform.SpecializableTransform2D;
import org.apache.sis.referencing.operation.transform.TransformAdapter2D;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.referencing.operation.transform.TranslationTransform;
import org.apache.sis.referencing.operation.transform.UnitConversion;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Static;
import org.apache.sis.util.internal.shared.DoubleDouble;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class MathTransforms
extends Static {
    private MathTransforms() {
    }

    public static LinearTransform identity(int dimension) {
        ArgumentChecks.ensurePositive((String)"dimension", (int)dimension);
        return IdentityTransform.create(dimension);
    }

    public static LinearTransform uniformTranslation(int dimension, double offset) {
        ArgumentChecks.ensurePositive((String)"dimension", (int)dimension);
        if (offset == 0.0) {
            return IdentityTransform.create(dimension);
        }
        switch (dimension) {
            case 0: {
                return IdentityTransform.create(0);
            }
            case 1: {
                return LinearTransform1D.create(1, offset);
            }
            case 2: {
                return new AffineTransform2D(1.0, 0.0, 0.0, 1.0, offset, offset);
            }
        }
        return new TranslationTransform(dimension, offset);
    }

    public static LinearTransform translation(double ... vector) {
        Serializable tr;
        switch (vector.length) {
            case 0: {
                return IdentityTransform.create(0);
            }
            case 1: {
                return LinearTransform1D.create(1, vector[0]);
            }
            case 2: {
                tr = new AffineTransform2D(1.0, 0.0, 0.0, 1.0, vector[0], vector[1]);
                break;
            }
            default: {
                tr = new TranslationTransform(vector);
            }
        }
        return tr.isIdentity() ? IdentityTransform.create(vector.length) : tr;
    }

    public static LinearTransform scale(double ... factors) {
        Serializable tr;
        switch (factors.length) {
            case 0: {
                return IdentityTransform.create(0);
            }
            case 1: {
                return LinearTransform1D.create(factors[0], null);
            }
            case 2: {
                tr = new AffineTransform2D(factors[0], 0.0, 0.0, factors[1], 0.0, 0.0);
                break;
            }
            default: {
                tr = new ScaleTransform(factors);
            }
        }
        return tr.isIdentity() ? IdentityTransform.create(factors.length) : tr;
    }

    public static LinearTransform linear(double scale, double offset) {
        return LinearTransform1D.create(scale, offset);
    }

    public static LinearTransform linear(Matrix matrix) {
        CopyTransform candidate;
        int targetDimension;
        int sourceDimension = matrix.getNumCol() - 1;
        if (sourceDimension == (targetDimension = matrix.getNumRow() - 1)) {
            if (matrix.isIdentity()) {
                return MathTransforms.identity(sourceDimension);
            }
            if (Matrices.isAffine(matrix)) {
                switch (sourceDimension) {
                    case 1: {
                        MatrixSIS m = MatrixSIS.castOrCopy(matrix);
                        return LinearTransform1D.create((Number)DoubleDouble.of((Number)m.getNumber(0, 0), (boolean)true), (Number)DoubleDouble.of((Number)m.getNumber(0, 1), (boolean)true));
                    }
                    case 2: {
                        return AffineTransform2D.create(matrix);
                    }
                }
            } else if (sourceDimension == 2) {
                return new ProjectiveTransform2D(matrix);
            }
        }
        if ((candidate = CopyTransform.create(matrix)) != null) {
            return candidate;
        }
        return new ProjectiveTransform(matrix).optimize();
    }

    public static LinearTransform tangent(MathTransform toApproximate, DirectPosition tangentPoint) throws TransformException {
        if (toApproximate instanceof LinearTransform) {
            ArgumentChecks.ensureDimensionMatches((String)"tangentPoint", (int)toApproximate.getSourceDimensions(), (DirectPosition)tangentPoint);
            return (LinearTransform)toApproximate;
        }
        return MathTransforms.linear(MathTransforms.getMatrix(toApproximate, tangentPoint));
    }

    public static MathTransform1D convert(UnitConverter converter) {
        return UnitConversion.create(Objects.requireNonNull(converter));
    }

    public static MathTransform1D interpolate(double[] preimage, double[] values) {
        return LinearInterpolator1D.create(preimage, values);
    }

    public static MathTransform specialize(MathTransform global, Map<Envelope, MathTransform> specializations) {
        ArgumentChecks.ensureNonNull((String)"global", (Object)global);
        if (specializations.isEmpty()) {
            return global;
        }
        SpecializableTransform tr = global.getSourceDimensions() == 2 && global.getTargetDimensions() == 2 ? new SpecializableTransform2D(global, specializations) : new SpecializableTransform(global, specializations);
        MathTransform substitute = tr.getSubstitute();
        return substitute != null ? substitute : tr;
    }

    public static MathTransform passThrough(int firstAffectedCoordinate, MathTransform subTransform, int numTrailingCoordinates) {
        int dimension;
        ArgumentChecks.ensureNonNull((String)"subTransform", (Object)subTransform);
        ArgumentChecks.ensurePositive((String)"firstAffectedCoordinate", (int)firstAffectedCoordinate);
        ArgumentChecks.ensurePositive((String)"numTrailingCoordinates", (int)numTrailingCoordinates);
        if (firstAffectedCoordinate == 0 && numTrailingCoordinates == 0) {
            return subTransform;
        }
        if (subTransform.isIdentity() && (dimension = subTransform.getSourceDimensions()) == subTransform.getTargetDimensions()) {
            return IdentityTransform.create(firstAffectedCoordinate + dimension + numTrailingCoordinates);
        }
        return PassThroughTransform.create(firstAffectedCoordinate, subTransform, numTrailingCoordinates);
    }

    public static MathTransform passThrough(int[] modifiedCoordinates, MathTransform subTransform, int resultDim) {
        ArgumentChecks.ensureNonNull((String)"modifiedCoordinates", (Object)modifiedCoordinates);
        BitSet bitset = new BitSet();
        int previous = -1;
        for (int i = 0; i < modifiedCoordinates.length; ++i) {
            int dim = modifiedCoordinates[i];
            String message = TransformSeparator.validate("modifiedCoordinates", i, previous, resultDim, dim);
            if (message != null) {
                throw new IllegalArgumentException(message);
            }
            bitset.set(dim);
            previous = dim;
        }
        try {
            return PassThroughTransform.create(bitset, subTransform, resultDim, null);
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static MathTransform compound(MathTransform ... components) {
        int sum = 0;
        int[] dimensions = new int[components.length];
        for (int i = 0; i < components.length; ++i) {
            MathTransform tr = components[i];
            ArgumentChecks.ensureNonNullElement((String)"components", (int)i, (Object)tr);
            dimensions[i] = tr.getSourceDimensions();
            sum += dimensions[i];
        }
        MathTransform compound = null;
        int firstAffectedCoordinate = 0;
        for (int i = 0; i < components.length; ++i) {
            MathTransform tr = components[i];
            tr = MathTransforms.passThrough(firstAffectedCoordinate, tr, sum - (firstAffectedCoordinate += dimensions[i]));
            compound = compound == null ? tr : MathTransforms.concatenate(compound, tr);
        }
        return compound;
    }

    public static MathTransform concatenate(MathTransform tr1, MathTransform tr2) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"tr1", (Object)tr1);
        ArgumentChecks.ensureNonNull((String)"tr2", (Object)tr2);
        try {
            return ConcatenatedTransform.create(DefaultMathTransformFactory.provider().caching(false), tr1, tr2);
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static MathTransform1D concatenate(MathTransform1D tr1, MathTransform1D tr2) throws MismatchedDimensionException {
        return (MathTransform1D)MathTransforms.concatenate((MathTransform)tr1, (MathTransform)tr2);
    }

    public static MathTransform2D concatenate(MathTransform2D tr1, MathTransform2D tr2) throws MismatchedDimensionException {
        return MathTransforms.bidimensional(MathTransforms.concatenate((MathTransform)tr1, (MathTransform)tr2));
    }

    public static MathTransform concatenate(MathTransform tr1, MathTransform tr2, MathTransform tr3) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"tr1", (Object)tr1);
        ArgumentChecks.ensureNonNull((String)"tr2", (Object)tr2);
        ArgumentChecks.ensureNonNull((String)"tr3", (Object)tr3);
        try {
            return ConcatenatedTransform.create(DefaultMathTransformFactory.provider().caching(false), tr1, tr2, tr3);
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static MathTransform1D concatenate(MathTransform1D tr1, MathTransform1D tr2, MathTransform1D tr3) throws MismatchedDimensionException {
        return (MathTransform1D)MathTransforms.concatenate((MathTransform)tr1, (MathTransform)tr2, (MathTransform)tr3);
    }

    public static MathTransform2D concatenate(MathTransform2D tr1, MathTransform2D tr2, MathTransform2D tr3) throws MismatchedDimensionException {
        return MathTransforms.bidimensional(MathTransforms.concatenate((MathTransform)tr1, (MathTransform)tr2, (MathTransform)tr3));
    }

    public static MathTransform2D bidimensional(MathTransform transform) {
        if (transform == null || transform instanceof MathTransform2D) {
            return (MathTransform2D)transform;
        }
        ArgumentChecks.ensureDimensionsMatch((String)"transform", (int)2, (int)2, (MathTransform)transform);
        return new TransformAdapter2D(transform);
    }

    public static List<MathTransform> getSteps(MathTransform transform) {
        if (transform != null) {
            if (transform instanceof ConcatenatedTransform) {
                return ((ConcatenatedTransform)transform).getSteps();
            }
            return List.of(transform);
        }
        return List.of();
    }

    public static MathTransform getFirstStep(MathTransform transform) {
        while (transform instanceof ConcatenatedTransform) {
            transform = ((ConcatenatedTransform)transform).transform1;
        }
        return transform;
    }

    public static MathTransform getLastStep(MathTransform transform) {
        while (transform instanceof ConcatenatedTransform) {
            transform = ((ConcatenatedTransform)transform).transform2;
        }
        return transform;
    }

    static boolean isLinear(Object transform) {
        return transform instanceof LinearTransform || transform instanceof AffineTransform || transform instanceof OnewayLinearTransform;
    }

    public static Matrix getMatrix(MathTransform transform) {
        if (transform instanceof LinearTransform) {
            return ((LinearTransform)transform).getMatrix();
        }
        if (transform instanceof OnewayLinearTransform) {
            return ((OnewayLinearTransform)transform).delegate.getMatrix();
        }
        if (transform instanceof AffineTransform) {
            return AffineTransforms2D.toMatrix((AffineTransform)transform);
        }
        return null;
    }

    public static Matrix getMatrix(MathTransform toApproximate, DirectPosition tangentPoint) throws TransformException {
        int srcDim = toApproximate.getSourceDimensions();
        ArgumentChecks.ensureDimensionMatches((String)"tangentPoint", (int)srcDim, (DirectPosition)tangentPoint);
        Matrix affine = MathTransforms.getMatrix(toApproximate);
        if (affine != null) {
            return affine;
        }
        ArgumentChecks.ensureNonNull((String)"tangentPoint", (Object)tangentPoint);
        int tgtDim = toApproximate.getTargetDimensions();
        double[] coordinates = new double[Math.max(tgtDim, srcDim + 1)];
        for (int i = 0; i < srcDim; ++i) {
            coordinates[i] = tangentPoint.getOrdinate(i);
        }
        Matrix derivative = MathTransforms.derivativeAndTransform(toApproximate, coordinates, 0, coordinates, 0);
        MatrixSIS m = Matrices.createAffine(derivative, new DirectPositionView.Double(coordinates, 0, tgtDim));
        coordinates = ArraysExt.resize((double[])coordinates, (int)(srcDim + 1));
        for (int i = 0; i < srcDim; ++i) {
            coordinates[i] = -tangentPoint.getOrdinate(i);
        }
        coordinates[srcDim] = 1.0;
        m.translate(coordinates);
        return m;
    }

    public static Optional<Envelope> getDomain(MathTransform evaluated) throws TransformException {
        if (evaluated instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)evaluated).getDomain(new DomainDefinition());
        }
        return Optional.empty();
    }

    public static Matrix derivativeAndTransform(MathTransform transform, double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws TransformException {
        if (transform instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)transform).transform(srcPts, srcOff, dstPts, dstOff, true);
        }
        Matrix derivative = transform.derivative((DirectPosition)new DirectPositionView.Double(srcPts, srcOff, transform.getSourceDimensions()));
        if (dstPts != null) {
            transform.transform(srcPts, srcOff, dstPts, dstOff, 1);
        }
        return derivative;
    }
}

