/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.temporal;

import java.time.temporal.Temporal;
import java.util.Date;
import org.apache.sis.pending.geoapi.temporal.IndeterminateValue;
import org.apache.sis.pending.geoapi.temporal.Instant;
import org.apache.sis.pending.geoapi.temporal.Period;
import org.apache.sis.temporal.DefaultInstant;
import org.apache.sis.temporal.DefaultPeriod;
import org.apache.sis.temporal.TemporalDate;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.temporal.TemporalPrimitive;

public final class TemporalObjects {
    private TemporalObjects() {
    }

    public static Instant createInstant(Temporal position) {
        return position == null ? DefaultInstant.UNKNOWN : new DefaultInstant(position, null);
    }

    public static Instant createInstant(Temporal position, IndeterminateValue indeterminate) {
        if (indeterminate == IndeterminateValue.UNKNOWN) {
            return DefaultInstant.UNKNOWN;
        }
        if (indeterminate == null || indeterminate == IndeterminateValue.BEFORE || indeterminate == IndeterminateValue.AFTER) {
            ArgumentChecks.ensureNonNull((String)"position", (Object)position);
        }
        return new DefaultInstant(position, indeterminate);
    }

    public static Instant createInstant(IndeterminateValue indeterminate) {
        ArgumentChecks.ensureNonNull((String)"indeterminate", (Object)((Object)indeterminate));
        if (indeterminate == IndeterminateValue.BEFORE || indeterminate == IndeterminateValue.AFTER) {
            throw new IllegalArgumentException(Errors.format((short)59, (Object)"indeterminate", (Object)((Object)indeterminate)));
        }
        return indeterminate == IndeterminateValue.UNKNOWN ? DefaultInstant.UNKNOWN : new DefaultInstant(null, indeterminate);
    }

    public static Period createPeriod(Temporal beginning, Temporal ending) {
        if (beginning == null && ending == null) {
            return null;
        }
        return new DefaultPeriod(TemporalObjects.createInstant(beginning), TemporalObjects.createInstant(ending));
    }

    public static Period createPeriod(Instant beginning, Instant ending) {
        if (beginning == null && ending == null) {
            return null;
        }
        if (beginning == null) {
            beginning = DefaultInstant.UNKNOWN;
        }
        if (ending == null) {
            ending = DefaultInstant.UNKNOWN;
        }
        return new DefaultPeriod(beginning, ending);
    }

    public static Temporal getInstant(TemporalPrimitive time) {
        if (time instanceof Instant) {
            return ((Instant)time).getPosition();
        }
        return null;
    }

    public static Date getAnyDate(TemporalPrimitive time) {
        Period p;
        Instant i;
        Temporal t = null;
        if (time instanceof Instant) {
            t = ((Instant)time).getPosition();
        } else if (time instanceof Period && ((i = (p = (Period)time).getEnding()) == null || (t = i.getPosition()) == null) && (i = p.getBeginning()) != null) {
            t = i.getPosition();
        }
        return TemporalDate.toDate(t);
    }
}

