/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import org.apache.sis.metadata.simple.SimpleCitation;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.internal.shared.Strings;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.Factory;

public abstract class AbstractFactory
implements Factory {
    protected AbstractFactory() {
    }

    public Citation getVendor() {
        String vendor;
        Package p = this.getClass().getPackage();
        if (p != null && (vendor = p.getImplementationVendor()) != null) {
            return new SimpleCitation(vendor);
        }
        return null;
    }

    public String toString() {
        Object[] args = new Object[2];
        try {
            Citation c = this.getVendor();
            if (c != null) {
                args[0] = "vendor";
                args[1] = c.getTitle();
            }
        }
        catch (BackingStoreException e) {
            args[0] = "exception";
            args[1] = e.toString();
        }
        return Strings.toString(this.getClass(), (Object[])args);
    }
}

