/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.gml;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.internal.shared.XmlUtilities;

public final class DateAdapter
extends XmlAdapter<XMLGregorianCalendar, Date> {
    public Date unmarshal(XMLGregorianCalendar value) {
        return value != null ? XmlUtilities.toDate(Context.current(), value) : null;
    }

    public XMLGregorianCalendar marshal(Date value) {
        if (value != null) {
            Context context = Context.current();
            try {
                XMLGregorianCalendar gc = XmlUtilities.toXML(context, value);
                XmlUtilities.trimTime(gc, true);
                return gc;
            }
            catch (DatatypeConfigurationException e) {
                Context.warningOccured(context, XmlAdapter.class, "marshal", e, true);
            }
        }
        return null;
    }
}

