/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.osgi.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.sling.ide.log.Logger;
import org.apache.sling.ide.osgi.OsgiClient;
import org.apache.sling.ide.osgi.OsgiClientException;
import org.apache.sling.ide.osgi.SourceReference;
import org.apache.sling.ide.osgi.impl.MavenSourceReferenceImpl;
import org.apache.sling.ide.osgi.impl.Polling;
import org.apache.sling.ide.transport.RepositoryInfo;
import org.osgi.framework.Version;

public class HttpOsgiClient
implements OsgiClient,
AutoCloseable {
    private static final int DEFAULT_SOCKET_TIMEOUT_SECONDS = 30;
    private static final int DEFAULT_CONNECT_TIMEOUT_SECONDS = 15;
    private final RepositoryInfo repositoryInfo;
    private final AuthCache authCache;
    private final Logger logger;
    private final CloseableHttpClient httpClient;

    public HttpOsgiClient(RepositoryInfo repositoryInfo, Logger logger) {
        this.repositoryInfo = repositoryInfo;
        this.logger = logger;
        HttpHost targetHost = new HttpHost(repositoryInfo.getUrl().getHost(), repositoryInfo.getUrl().getPort(), repositoryInfo.getUrl().getScheme());
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(targetHost), (Credentials)new UsernamePasswordCredentials(repositoryInfo.getUsername(), repositoryInfo.getPassword()));
        this.authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        this.authCache.put(targetHost, (AuthScheme)basicAuth);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(15000).setSocketTimeout(30000).build();
        this.httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setDefaultRequestConfig(requestConfig).build();
    }

    @Override
    public Version getBundleVersion(String bundleSymbolicName) throws OsgiClientException {
        BundleInfo info = this.getBundleInfo(bundleSymbolicName);
        if (info == null) {
            return null;
        }
        return info.getVersion();
    }

    public HttpClientContext createContextForPreemptiveBasicAuth() {
        HttpClientContext localContext = HttpClientContext.create();
        localContext.setAuthCache(this.authCache);
        return localContext;
    }

    public void waitForBundleUpdatedAndActive(final String bundleSymbolicName, long timeout, long delay, Instant installationTime) throws TimeoutException, InterruptedException {
        final Instant truncatedInstallationTime = installationTime.truncatedTo(ChronoUnit.SECONDS);
        Polling p = new Polling(){

            @Override
            public Boolean call() throws Exception {
                BundleInfo info = HttpOsgiClient.this.getBundleInfo(bundleSymbolicName);
                if (info != null) {
                    HttpOsgiClient.this.logger.trace("Bundle {0}, State {1}, Modification date {2}, Installation date {3}", new Object[]{bundleSymbolicName, info.status, info.getLastModification(), truncatedInstallationTime});
                    return !info.getLastModification().isBefore(truncatedInstallationTime) && info.status == BundleInfo.Status.ACTIVE;
                }
                HttpOsgiClient.this.logger.trace("Could not get bundle info for bsn {0}", bundleSymbolicName);
                return false;
            }

            @Override
            protected String message() {
                return "Bundle " + bundleSymbolicName + " was not installed/updated in %1$d ms";
            }
        };
        p.poll(timeout, delay);
    }

    @Override
    public void waitForComponentRegistered(final String componentNameOrId, long timeout, long delay) throws TimeoutException, InterruptedException {
        Polling p = new Polling(){

            @Override
            public Boolean call() throws Exception {
                ComponentsInfo info = HttpOsgiClient.this.getComponentsInfo(componentNameOrId);
                if (info != null) {
                    return info.components[0].status == ComponentInfo.Status.SATISFIED || info.components[0].status == ComponentInfo.Status.ACTIVE;
                }
                HttpOsgiClient.this.logger.trace("Could not get component info for component name {0}", componentNameOrId);
                return false;
            }

            @Override
            protected String message() {
                return "Component " + componentNameOrId + " was not registered in %1$d ms";
            }
        };
        p.poll(timeout, delay);
    }

    public ComponentsInfo getComponentsInfo(String componentNameOrId) throws OsgiClientException {
        return this.executeJsonGetRequest("system/console/components/" + componentNameOrId + ".json", ComponentsInfo.class, "get DS component info", true);
    }

    public BundleInfo getBundleInfo(String bundleSymbolicNameOrId) throws OsgiClientException {
        BundlesInfo info = this.executeJsonGetRequest("system/console/bundles/" + bundleSymbolicNameOrId + ".json", BundlesInfo.class, "get bundle info", true);
        if (info == null) {
            return null;
        }
        return info.bundles[0];
    }

    @Override
    public void installBundle(InputStream in, String bundleSymbolicName) throws OsgiClientException {
        if (in == null) {
            throw new IllegalArgumentException("in may not be null");
        }
        if (bundleSymbolicName == null) {
            throw new IllegalArgumentException("bundleSymbolicName may not be null");
        }
        HttpPost filePost = new HttpPost(this.repositoryInfo.getUrl().resolve("system/console/install"));
        try {
            filePost.setHeader("referer", "about:blank");
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
            entityBuilder.addTextBody("action", "install");
            entityBuilder.addTextBody("_noredir_", "_noredir_");
            entityBuilder.addTextBody("bundlestart", "start");
            entityBuilder.addBinaryBody("bundlefile", in, ContentType.DEFAULT_BINARY, bundleSymbolicName);
            filePost.setEntity(entityBuilder.build());
            this.logger.trace("Installing bundle {0} via POST to {1}", bundleSymbolicName, filePost.getURI());
            Instant installationTime = Instant.now();
            this.httpClient.execute((HttpUriRequest)filePost, (ResponseHandler)new BasicLoggingResponseHandler(), (HttpContext)this.createContextForPreemptiveBasicAuth());
            this.waitForBundleUpdatedAndActive(bundleSymbolicName, 20000L, 500L, installationTime);
        }
        catch (IOException e) {
            throw new OsgiClientException("Error installing bundle " + bundleSymbolicName + " via " + String.valueOf(filePost), e);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new OsgiClientException("Error getting status of bundle  " + bundleSymbolicName + " after installation/update ", e);
        }
    }

    @Override
    public boolean uninstallBundle(String bundleSymbolicName) throws OsgiClientException {
        HttpPost postMethod = new HttpPost(this.repositoryInfo.getUrl().resolve("system/console/bundles/" + bundleSymbolicName));
        try {
            List<BasicNameValuePair> parameters = Collections.singletonList(new BasicNameValuePair("action", "uninstall"));
            postMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
            this.logger.trace("Uninstalling bundle via {0}", postMethod);
            this.httpClient.execute((HttpUriRequest)postMethod, (ResponseHandler)new BasicLoggingResponseHandler(), (HttpContext)this.createContextForPreemptiveBasicAuth());
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                this.logger.trace("No bundle found with bsn {0}, skipping uninstallation", bundleSymbolicName);
                return false;
            }
            throw new OsgiClientException("Error uninstalling bundle " + bundleSymbolicName + " via " + String.valueOf(postMethod));
        }
        catch (IOException e) {
            throw new OsgiClientException("Error uninstalling bundle " + bundleSymbolicName + " via " + String.valueOf(postMethod));
        }
        return true;
    }

    @Override
    public void installBundle(Path explodedBundleLocation) throws OsgiClientException {
        if (explodedBundleLocation == null) {
            throw new IllegalArgumentException("explodedBundleLocation may not be null");
        }
        List<BasicNameValuePair> parameters = Collections.singletonList(new BasicNameValuePair("dir", explodedBundleLocation.toString()));
        try {
            HttpPost request = new HttpPost(this.repositoryInfo.getUrl().resolve("system/sling/tooling/install"));
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
            BundleInstallerResult result = this.executeJsonRequest((HttpRequestBase)request, BundleInstallerResult.class, "install local bundle from " + explodedBundleLocation.toString(), false);
            if (!result.isSuccessful()) {
                String errorMessage = !result.hasMessage() ? "Bundle deployment failed, please check the Sling logs" : result.getMessage();
                throw new OsgiClientException(errorMessage);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new OsgiClientException("Cannot install local bundle due to unsupported encoding", e);
        }
    }

    @Override
    public List<SourceReference> findSourceReferences() throws OsgiClientException {
        SourceBundleData[] sourceBundleData = this.executeJsonGetRequest("system/sling/tooling/sourceReferences.json", SourceBundleData[].class, "find source references", false);
        ArrayList<SourceReference> res = new ArrayList<SourceReference>(sourceBundleData.length);
        for (SourceBundleData sourceData : sourceBundleData) {
            for (SourceReferenceFromJson ref : sourceData.sourceReferences) {
                if (!ref.isMavenType()) continue;
                res.add(ref.getMavenSourceReference());
            }
        }
        return res;
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    private <T> T executeJsonGetRequest(String relativePath, Class<T> jsonObjectClass, String requestLabel, boolean returnNullFor404Status) throws OsgiClientException {
        HttpGet request = new HttpGet(this.repositoryInfo.getUrl().resolve(relativePath));
        return this.executeJsonRequest((HttpRequestBase)request, jsonObjectClass, requestLabel, returnNullFor404Status);
    }

    private <T> T executeJsonRequest(HttpRequestBase request, final Class<T> jsonObjectClass, String requestLabel, boolean returnNullFor404Status) throws OsgiClientException {
        try {
            this.logger.trace("{0} via {1}", requestLabel, request);
            return (T)this.httpClient.execute((HttpUriRequest)request, (ResponseHandler)new LoggingAbstractResponseHandler<T>(){

                @Override
                public T handleEntity(HttpEntity entity) throws IOException {
                    return HttpOsgiClient.parseJson(jsonObjectClass, entity.getContent(), HttpOsgiClient.getCharsetOrDefault(entity));
                }
            }, (HttpContext)this.createContextForPreemptiveBasicAuth());
        }
        catch (HttpResponseException e) {
            if (returnNullFor404Status && e.getStatusCode() == 404) {
                return null;
            }
            throw new OsgiClientException("Unexpected response code " + e.getStatusCode() + " during " + requestLabel + " via " + String.valueOf(request), e);
        }
        catch (IOException e) {
            throw new OsgiClientException("Cannot " + requestLabel + " via " + String.valueOf(request), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> T parseJson(Class<T> jsonObjectClass, InputStream input, Charset charset) throws IOException {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(new TypeToken<Map<String, Object>>(){}.getType(), (Object)new PropertyTypeAdapter());
        Gson gson = builder.create();
        try (JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(input, charset));){
            Object object = gson.fromJson(jsonReader, jsonObjectClass);
            return (T)object;
        }
        catch (JsonParseException e) {
            throw new IOException("Error parsing JSON response", e);
        }
    }

    private static Charset getCharsetOrDefault(HttpEntity entity) {
        Charset charset = ContentType.getOrDefault((HttpEntity)entity).getCharset();
        if (charset == null) {
            charset = StandardCharsets.ISO_8859_1;
        }
        return charset;
    }

    static final class BundleInfo {
        String id;
        String symbolicName;
        @SerializedName(value="state")
        Status status;
        private String version;
        @SerializedName(value="props")
        private Map<String, Object> properties;
        static final DateTimeFormatter DATE_TOSTRING_FORMAT = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ROOT);

        BundleInfo() {
        }

        Instant getLastModification() {
            return ZonedDateTime.parse(this.properties.get("Last Modification").toString(), DATE_TOSTRING_FORMAT).toInstant();
        }

        Version getVersion() {
            return new Version(this.version);
        }

        public static enum Status {
            INSTALLED("Installed"),
            RESOLVED("Resolved"),
            FRAGMENT("Fragment"),
            STARTING("Starting"),
            ACTIVE("Active"),
            STOPPING("Stopping"),
            UNKNOWN("unknown");

            String value;

            private Status(String value) {
                this.value = value;
            }

            public static Status value(String o) {
                for (Status s : Status.values()) {
                    if (!s.value.equalsIgnoreCase(o)) continue;
                    return s;
                }
                return UNKNOWN;
            }

            public String toString() {
                return this.value;
            }
        }
    }

    static final class ComponentsInfo {
        @SerializedName(value="data")
        ComponentInfo[] components;

        ComponentsInfo() {
        }
    }

    static final class BundlesInfo {
        @SerializedName(value="data")
        BundleInfo[] bundles;

        BundlesInfo() {
        }
    }

    public final class BasicLoggingResponseHandler
    extends LoggingAbstractResponseHandler<String> {
        @Override
        public String handleEntity(HttpEntity entity) throws IOException {
            return EntityUtils.toString((HttpEntity)entity);
        }
    }

    private static final class BundleInstallerResult {
        private String status;
        private String message;

        private BundleInstallerResult() {
        }

        public boolean hasMessage() {
            return this.message != null && this.message.length() > 0;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isSuccessful() {
            return "OK".equalsIgnoreCase(this.status);
        }
    }

    private static final class SourceBundleData {
        @SerializedName(value="Bundle-SymbolicName")
        private String bsn;
        @SerializedName(value="Bundle-Version")
        private String version;
        private List<SourceReferenceFromJson> sourceReferences;

        private SourceBundleData() {
        }
    }

    private static final class SourceReferenceFromJson {
        @SerializedName(value="__type__")
        private String type;
        private String groupId;
        private String artifactId;
        private String version;

        private SourceReferenceFromJson() {
        }

        public boolean isMavenType() {
            return "maven".equals(this.type);
        }

        public MavenSourceReferenceImpl getMavenSourceReference() {
            if (!this.isMavenType()) {
                throw new IllegalStateException("The type is not a Maven source reference but a " + this.type);
            }
            return new MavenSourceReferenceImpl(this.groupId, this.artifactId, this.version);
        }
    }

    static final class PropertyTypeAdapter
    extends TypeAdapter<Map<String, Object>> {
        PropertyTypeAdapter() {
        }

        public void write(JsonWriter out, Map<String, Object> value) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Map<String, Object> read(JsonReader in) throws IOException {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            in.beginArray();
            while (in.peek() == JsonToken.BEGIN_OBJECT) {
                in.beginObject();
                String key = null;
                LinkedList<Object> value = null;
                for (int n = 0; n < 2; ++n) {
                    String propName = in.nextName();
                    if (propName.equals("key")) {
                        key = in.nextString();
                        continue;
                    }
                    if (propName.equals("value")) {
                        JsonToken token = in.peek();
                        if (token == JsonToken.BEGIN_ARRAY) {
                            in.beginArray();
                            LinkedList<Object> list = new LinkedList<Object>();
                            while (in.peek() != JsonToken.END_ARRAY) {
                                list.add(this.extractValue(in));
                            }
                            in.endArray();
                            value = list;
                            continue;
                        }
                        value = this.extractValue(in);
                        continue;
                    }
                    throw new IOException("Unsupported field in properties" + propName);
                }
                Objects.requireNonNull(key);
                Objects.requireNonNull(value);
                properties.put(key, value);
                in.endObject();
            }
            in.endArray();
            return properties;
        }

        private Object extractValue(JsonReader in) throws IOException {
            Object value;
            JsonToken token = in.peek();
            if (token == JsonToken.STRING) {
                value = in.nextString();
            } else if (token == JsonToken.BOOLEAN) {
                value = in.nextBoolean();
            } else if (token == JsonToken.NUMBER) {
                value = in.nextDouble();
            } else {
                in.skipValue();
                value = "Nested array/object";
            }
            return value;
        }
    }

    public abstract class LoggingAbstractResponseHandler<T>
    implements ResponseHandler<T> {
        public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            if (statusLine.getStatusCode() >= 300) {
                HttpOsgiClient.this.logger.trace("Received failure response " + String.valueOf(statusLine) + ":" + EntityUtils.toString((HttpEntity)entity), new Object[0]);
                EntityUtils.consume((HttpEntity)entity);
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            return entity == null ? null : (T)this.handleEntity(entity);
        }

        public abstract T handleEntity(HttpEntity var1) throws IOException;
    }

    static final class ComponentInfo {
        String pid;
        String name;
        @SerializedName(value="state")
        Status status;

        ComponentInfo() {
        }

        public static enum Status {
            ACTIVE("active"),
            SATISFIED("satisfied"),
            UNSATISFIED_CONFIGURATION("unsatisfied (configuration)"),
            UNSATISFIED_REFERENCE("unsatisfied (reference)"),
            FAILED_ACTIVATION("failed activation"),
            UNKNOWN("unknown");

            String value;

            private Status(String value) {
                this.value = value;
            }

            public static Status value(String o) {
                for (Status s : Status.values()) {
                    if (!s.value.equalsIgnoreCase(o)) continue;
                    return s;
                }
                return UNKNOWN;
            }

            public String toString() {
                return this.value;
            }
        }
    }
}

