/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.transport;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jcr.nodetype.NodeType;
import org.apache.sling.ide.transport.NodeTypeRegistry;
import org.apache.sling.ide.transport.RepositoryException;

public class FallbackNodeTypeRegistry
implements NodeTypeRegistry {
    private final List<NodeType> nodeTypes = new ArrayList<NodeType>();

    public static FallbackNodeTypeRegistry createRegistryWithDefaultNodeTypes() {
        FallbackNodeTypeRegistry registry = new FallbackNodeTypeRegistry();
        registry.addNodeType("nt:file", new String[]{"nt:hierarchyNode"});
        registry.addNodeType("nt:folder", new String[]{"nt:hierarchyNode"});
        registry.addNodeType("nt:hierarchyNode", new String[]{"mix:created", "nt:base"});
        registry.addNodeType("nt:unstructured", new String[]{"nt:base"});
        registry.addNodeType("nt:base", new String[0]);
        registry.addNodeType("sling:OsgiConfig", new String[]{"nt:hierarchyNode", "nt:unstructured"});
        registry.addNodeType("sling:Folder", new String[]{"nt:folder"});
        registry.addNodeType("sling:OrderedFolder", new String[]{"sling:Folder"});
        registry.addNodeType("vlt:FullCoverage", new String[0]);
        registry.addNodeType("mix:created", new String[0]);
        return registry;
    }

    @Override
    public boolean isAllowedPrimaryChildNodeType(String parentNodeType, String childNodeType) throws RepositoryException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Collection<String> getAllowedPrimaryChildNodeTypes(String parentNodeType) throws RepositoryException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void addNodeType(String name, String[] superTypeNames) {
        this.nodeTypes.add(this.getNodeTypeProxy(name, superTypeNames));
    }

    private NodeType getNodeTypeProxy(final String name, final String[] superTypeNames) {
        InvocationHandler ih = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("getName") && method.getParameterTypes().length == 0) {
                    return name;
                }
                if (method.getName().equals("getDeclaredSupertypeNames") && method.getParameterTypes().length == 0) {
                    return superTypeNames;
                }
                if (method.getName().equals("getSupertypes") && method.getParameterTypes().length == 0) {
                    NodeType[] superTypes = new NodeType[superTypeNames.length];
                    for (int i = 0; i < superTypeNames.length; ++i) {
                        NodeType aSuperType;
                        String aSuperTypeName = superTypeNames[i];
                        superTypes[i] = aSuperType = FallbackNodeTypeRegistry.this.getNodeType(aSuperTypeName);
                    }
                    return superTypes;
                }
                if (method.getDeclaringClass() == Object.class) {
                    if (method.getName().equals("toString") && method.getParameterTypes().length == 0) {
                        return proxy.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(proxy));
                    }
                    if (method.getName().equals("hashCode") && method.getParameterTypes().length == 0) {
                        return System.identityHashCode(proxy);
                    }
                    if (method.getName().equals("equals") && method.getParameterTypes().length == 1) {
                        return proxy == args[0];
                    }
                }
                return null;
            }
        };
        NodeType nodeType = (NodeType)Proxy.newProxyInstance(NodeType.class.getClassLoader(), new Class[]{NodeType.class}, ih);
        return nodeType;
    }

    @Override
    public List<NodeType> getNodeTypes() {
        return Collections.unmodifiableList(this.nodeTypes);
    }

    @Override
    public NodeType getNodeType(String name) {
        for (NodeType nt : this.nodeTypes) {
            if (!nt.getName().equals(name)) continue;
            return nt;
        }
        return null;
    }
}

