/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.internal.sync.content;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.sling.ide.eclipse.core.EclipseResources;
import org.apache.sling.ide.eclipse.core.internal.sync.content.EclipseWorkspaceFile;
import org.apache.sling.ide.eclipse.core.internal.sync.content.EclipseWorkspaceProject;
import org.apache.sling.ide.eclipse.core.internal.sync.content.EclipseWorkspaceResource;
import org.apache.sling.ide.sync.content.WorkspaceDirectory;
import org.apache.sling.ide.sync.content.WorkspaceFile;
import org.apache.sling.ide.sync.content.WorkspacePath;
import org.apache.sling.ide.sync.content.WorkspaceProject;
import org.apache.sling.ide.sync.content.WorkspaceResource;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class EclipseWorkspaceDirectory
extends EclipseWorkspaceResource
implements WorkspaceDirectory {
    public EclipseWorkspaceDirectory(IFolder folder, Set<String> ignoredFileNames) {
        super((IResource)folder, ignoredFileNames);
    }

    protected IFolder getResource() {
        return (IFolder)super.getResource();
    }

    @Override
    public WorkspaceProject getProject() {
        return new EclipseWorkspaceProject(this.getResource().getProject(), this.getIgnoredFileNames());
    }

    @Override
    public WorkspacePath getLocalPath() {
        return new WorkspacePath(this.getResource().getFullPath().toPortableString());
    }

    public WorkspaceFile getFile(WorkspacePath relativePath) {
        return new EclipseWorkspaceFile(this.getResource().getFile(relativePath.asPortableString()), this.getIgnoredFileNames());
    }

    public WorkspaceDirectory getDirectory(WorkspacePath relativePath) {
        return new EclipseWorkspaceDirectory(this.getResource().getFolder(relativePath.asPortableString()), this.getIgnoredFileNames());
    }

    public List<WorkspaceResource> getChildren() {
        try {
            return Arrays.stream(this.getResource().members()).map(EclipseResources::create).collect(Collectors.toList());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }
}

