/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.internal.sync.content;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Set;
import org.apache.sling.ide.eclipse.core.internal.sync.content.EclipseWorkspaceProject;
import org.apache.sling.ide.sync.content.WorkspacePath;
import org.apache.sling.ide.sync.content.WorkspaceProject;
import org.apache.sling.ide.sync.content.WorkspaceResource;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public abstract class EclipseWorkspaceResource
implements WorkspaceResource {
    private final IResource resource;
    private final Set<String> ignoredFileNames;

    protected EclipseWorkspaceResource(IResource resource, Set<String> ignoredFileNames) {
        this.resource = resource;
        this.ignoredFileNames = ignoredFileNames;
    }

    public boolean exists() {
        return this.resource.exists();
    }

    public boolean isIgnored() {
        return this.ignoredFileNames.contains(this.getName()) || this.resource.isTeamPrivateMember(512);
    }

    public WorkspacePath getLocalPath() {
        return new WorkspacePath(this.resource.getFullPath().toPortableString());
    }

    public Path getOSPath() {
        return Paths.get(this.resource.getLocation().toOSString(), new String[0]);
    }

    public WorkspaceProject getProject() {
        return new EclipseWorkspaceProject(this.resource.getProject(), this.ignoredFileNames);
    }

    public long getLastModified() {
        return this.resource.getModificationStamp();
    }

    public Object getTransientProperty(String propertyName) {
        try {
            return this.resource.getSessionProperty(new QualifiedName("org.apache.sling.ide.eclipse-core", propertyName));
        }
        catch (CoreException coreException) {
            throw new RuntimeException();
        }
    }

    protected IResource getResource() {
        return this.resource;
    }

    protected Set<String> getIgnoredFileNames() {
        return this.ignoredFileNames;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EclipseWorkspaceResource)) {
            return false;
        }
        EclipseWorkspaceResource other = (EclipseWorkspaceResource)obj;
        return Objects.equals(this.resource, other.resource);
    }

    public String toString() {
        return this.resource.toString();
    }
}

