/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.internal.validation;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import org.apache.sling.ide.eclipse.core.internal.Activator;
import org.apache.sling.ide.log.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.xml.core.internal.validation.core.AbstractNestedValidator;
import org.eclipse.wst.xml.core.internal.validation.core.NestedValidatorContext;
import org.eclipse.wst.xml.core.internal.validation.eclipse.Validator;

public class IgnoreMissingGrammarXmlValidator
extends Validator {
    private final String GET_FILE = "getFile";
    private final String GET_PROJECT_FILES = "getAllFiles";
    private final String GET_INPUTSTREAM = "inputStream";

    protected void setupValidation(NestedValidatorContext context) {
        super.setupValidation(context);
        this.indicateNoGrammar = 0;
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        ValidationResult result = new ValidationResult();
        IFile file = null;
        if (resource instanceof IFile) {
            file = (IFile)resource;
        }
        if (file != null && IgnoreMissingGrammarXmlValidator.shouldValidate(file)) {
            IReporter reporter = result.getReporter(monitor);
            NestedValidatorContext nestedcontext = this.getNestedContext(state, false);
            boolean teardownRequired = false;
            if (nestedcontext == null) {
                nestedcontext = this.getNestedContext(state, true);
                nestedcontext.setProject(file.getProject());
                this.setupValidation(nestedcontext);
                teardownRequired = true;
            } else {
                nestedcontext.setProject(file.getProject());
            }
            this.doValidate(file, null, result, reporter, nestedcontext);
            if (teardownRequired) {
                this.teardownValidation(nestedcontext);
            }
        }
        return result;
    }

    public IStatus validateInJob(IValidationContext context, IReporter reporter) throws ValidationException {
        NestedValidatorContext nestedcontext = new NestedValidatorContext();
        this.setupValidation(nestedcontext);
        String[] fileURIs = context.getURIs();
        if (fileURIs != null && fileURIs.length > 0) {
            int numFiles = fileURIs.length;
            int i = 0;
            while (i < numFiles && !reporter.isCancelled()) {
                Object[] parms;
                IFile file;
                String fileName = fileURIs[i];
                if (fileName != null && (file = (IFile)context.loadModel("getFile", parms = new Object[]{fileName})) != null && IgnoreMissingGrammarXmlValidator.shouldValidate(file)) {
                    nestedcontext.setProject(file.getProject());
                    if (context.loadModel("inputStream") instanceof InputStream) {
                        this.doValidate(file, (InputStream)context.loadModel("inputStream"), null, reporter, nestedcontext);
                    } else {
                        this.doValidate(file, null, null, reporter, nestedcontext);
                    }
                }
                ++i;
            }
        } else {
            Object[] parms = new Object[]{this.getValidatorID()};
            Collection files = (Collection)context.loadModel("getAllFiles", parms);
            if (files != null) {
                Iterator iter = files.iterator();
                while (iter.hasNext() && !reporter.isCancelled()) {
                    IFile file = (IFile)iter.next();
                    if (!IgnoreMissingGrammarXmlValidator.shouldValidate(file)) continue;
                    this.doValidate(file, null, null, reporter, nestedcontext);
                }
            }
        }
        this.teardownValidation(nestedcontext);
        if (reporter.isCancelled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private void doValidate(IFile file, InputStream inputstream, ValidationResult result, IReporter reporter, NestedValidatorContext context) {
        try {
            Method method = AbstractNestedValidator.class.getDeclaredMethod("validate", IFile.class, InputStream.class, ValidationResult.class, IReporter.class, NestedValidatorContext.class);
            method.setAccessible(true);
            method.invoke((Object)this, file, inputstream, result, reporter, context);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Logger logger = Activator.getDefault().getPluginLogger();
            logger.error("Failed calling validate method on AbstractNestedValidator, probably WTP version is incompatible.", (Throwable)e);
        }
    }

    private static boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && (resource.getName().charAt(0) != '.' || ".content.xml".equals(resource.getName()))) continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }
}

