/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.m2e.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.project.MavenProject;
import org.apache.sling.ide.eclipse.core.ConfigurationHelper;
import org.apache.sling.ide.eclipse.m2e.internal.AbstractProjectConfigurator;
import org.apache.sling.ide.eclipse.m2e.internal.Activator;
import org.apache.sling.ide.eclipse.m2e.internal.MavenProjectUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.common.project.facet.core.internal.JavaFacetUtil;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ContentPackageProjectConfigurator
extends AbstractProjectConfigurator {
    private static final String M2E_ACTIVE = "sling.ide.m2e.contentpackage.active";
    private static final String M2E_JAVA_FACET_VERSION = "sling.ide.m2e.contentpackage.javaFacetVersion";
    private static final String M2E_WEB_FACET_VERSION = "sling.ide.m2e.contentpackage.webFacetVersion";

    public void configure(ProjectConfigurationRequest configRequest, IProgressMonitor progressMonitor) throws CoreException {
        boolean active;
        IProject project = configRequest.mavenProjectFacade().getProject();
        IFile pomFile = configRequest.mavenProjectFacade().getPom();
        this.deleteMarkers((IResource)pomFile);
        if (!this.getPreferences().isContentPackageProjectConfiguratorEnabled()) {
            ContentPackageProjectConfigurator.trace("M2E project configurator for packing type 'content-package' was disabled through preference.", new Object[0]);
            return;
        }
        MavenProject mavenProject = configRequest.mavenProject();
        boolean bl = active = !"false".equalsIgnoreCase(mavenProject.getProperties().getProperty(M2E_ACTIVE));
        if (!active) {
            ContentPackageProjectConfigurator.trace("M2E project configurator for packing type 'content-package' was disabled with Maven property {0}", M2E_ACTIVE);
            return;
        }
        ContentPackageProjectConfigurator.trace("Configuring {0} with packaging 'content-package'...", mavenProject);
        try {
            Optional<java.nio.file.Path> contentSyncPath = MavenProjectUtils.guessJcrRootFolder(mavenProject);
            if (!contentSyncPath.isPresent()) {
                this.addMarker((IResource)pomFile, "Could not detect jcr_root path for this content package!", 2);
                return;
            }
            String jcrRootPath = contentSyncPath.get().toString();
            ConfigurationHelper.convertToContentPackageProject((IProject)project, (IProgressMonitor)progressMonitor, (IPath)Path.fromOSString((String)jcrRootPath));
            if (this.getPreferences().isWtpFacetsEnabledInContentPackageProjectConfigurator()) {
                new WtpProjectConfigurer(configRequest, project, jcrRootPath).configure(progressMonitor);
                ContentPackageProjectConfigurator.trace("WTP facets for {0} added", mavenProject);
            } else {
                ContentPackageProjectConfigurator.trace("WTP facets for packing type 'content-package' are disabled through preferences.", new Object[0]);
            }
        }
        catch (IOException e) {
            Activator.getDefault().getPluginLogger().warn("Could not determine jcr_root for project: " + String.valueOf(mavenProject.getBasedir()) + ": " + String.valueOf(e), (Throwable)e);
        }
        ContentPackageProjectConfigurator.trace("Done converting .", new Object[0]);
    }

    private void addNatures(IProject project, String[] natureIdsToAdd, IProgressMonitor progressMonitor, IResource pomResource) throws CoreException {
        ContentPackageProjectConfigurator.trace("Adding natures {0} to project {1} ", Arrays.toString(natureIdsToAdd), project);
        IProjectDescription description = project.getDescription();
        String[] oldNatureIds = description.getNatureIds();
        TreeSet<String> newNatureIdSet = new TreeSet<String>();
        newNatureIdSet.addAll(Arrays.asList(oldNatureIds));
        if (newNatureIdSet.addAll(Arrays.asList(natureIdsToAdd))) {
            Object[] newNatureIds = newNatureIdSet.toArray(new String[newNatureIdSet.size()]);
            IStatus status = project.getWorkspace().validateNatureSet((String[])newNatureIds);
            if (status.getCode() == 0) {
                ContentPackageProjectConfigurator.trace("Modifiying natures of project {1} to {0}", Arrays.toString(newNatureIds), project);
                description.setNatureIds((String[])newNatureIds);
                project.setDescription(description, 2, progressMonitor);
            } else {
                StatusManager.getManager().handle(status, 3);
                this.addMarker(pomResource, "Could not add all necessary WTP natures: " + status.getMessage(), 2);
            }
        } else {
            ContentPackageProjectConfigurator.trace("Not modifiying natures of project {1} as required natures {0} are already set ", Arrays.toString(natureIdsToAdd), project);
        }
    }

    private class WtpProjectConfigurer {
        private final ProjectConfigurationRequest configRequest;
        private final IProject project;
        private final String jcrRootPath;

        WtpProjectConfigurer(ProjectConfigurationRequest configRequest, IProject project, String jcrRootPath) {
            this.configRequest = configRequest;
            this.project = project;
            this.jcrRootPath = jcrRootPath;
        }

        void configure(IProgressMonitor progressMonitor) throws CoreException {
            ContentPackageProjectConfigurator.trace("Configuring content-package with WTP facets/natures", new Object[0]);
            ContentPackageProjectConfigurator.this.addNatures(this.project, this.getDefaultWtpNatures(), progressMonitor, (IResource)this.configRequest.mavenProjectFacade().getPom());
            this.addWtpFacets(progressMonitor);
        }

        void addWtpFacets(IProgressMonitor progressMonitor) throws CoreException {
            String webFacetVersion;
            String javaFacetVersion;
            MavenProject mavenProject = this.configRequest.mavenProject();
            String javaFacetVersionPropertyValue = mavenProject.getProperties().getProperty(ContentPackageProjectConfigurator.M2E_JAVA_FACET_VERSION, "");
            if (!javaFacetVersionPropertyValue.isBlank()) {
                javaFacetVersion = javaFacetVersionPropertyValue;
                ContentPackageProjectConfigurator.trace("Configured Java facet version {0} from pom property {1}", javaFacetVersion, ContentPackageProjectConfigurator.M2E_JAVA_FACET_VERSION);
            } else {
                javaFacetVersion = JavaFacetUtil.getCompilerLevel((IProject)this.project);
                ContentPackageProjectConfigurator.trace("Configured Java facet version {0} using JavaFacetUtil", javaFacetVersion);
            }
            String webFacetVersionPropertyValue = mavenProject.getProperties().getProperty(ContentPackageProjectConfigurator.M2E_WEB_FACET_VERSION, "");
            if (!webFacetVersionPropertyValue.isBlank()) {
                webFacetVersion = webFacetVersionPropertyValue;
                ContentPackageProjectConfigurator.trace("Configured Web facet version {0} from pom property {1}", webFacetVersion, ContentPackageProjectConfigurator.M2E_WEB_FACET_VERSION);
            } else {
                webFacetVersion = MavenProjectUtils.guessServletApiVersion(mavenProject);
                ContentPackageProjectConfigurator.trace("Configured Web facet version {0} from project dependencies", webFacetVersion);
            }
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this.project, (boolean)true, (IProgressMonitor)progressMonitor);
            LinkedHashSet<IFacetedProject.Action> actions = new LinkedHashSet<IFacetedProject.Action>();
            this.installJavaFacet(actions, this.project, facetedProject, javaFacetVersion);
            IProjectFacetVersion webFv = ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion(webFacetVersion);
            IDataModel webModelCfg = this.getWebModelConfig(this.jcrRootPath);
            if (!facetedProject.hasProjectFacet(WebFacetUtils.WEB_FACET)) {
                this.removeConflictingFacets(facetedProject, webFv, actions);
                actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, webFv, (Object)webModelCfg));
            } else {
                IProjectFacetVersion projectFacetVersion = facetedProject.getProjectFacetVersion(WebFacetUtils.WEB_FACET);
                if (webFv.getVersionString() != null && !webFv.getVersionString().equals(projectFacetVersion.getVersionString())) {
                    actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, webFv, (Object)webModelCfg));
                }
            }
            if (!actions.isEmpty()) {
                try {
                    facetedProject.modify(actions, progressMonitor);
                }
                catch (Exception e) {
                    Activator.getDefault().getPluginLogger().warn("Could not add facets to project: " + String.valueOf(e), (Throwable)e);
                }
            }
        }

        private IDataModel getWebModelConfig(String warSourceDirectory) {
            IDataModel webModelCfg = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetInstallDataModelProvider());
            webModelCfg.setProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", (Object)warSourceDirectory);
            webModelCfg.setProperty("IWebFacetInstallDataModelProperties.CONTEXT_ROOT", (Object)"/");
            webModelCfg.setProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", (Object)false);
            return webModelCfg;
        }

        private void installJavaFacet(Set<IFacetedProject.Action> actions, IProject project, IFacetedProject facetedProject, String javaFacetVersion) {
            IProjectFacetVersion javaFv = JavaFacet.FACET.getVersion(javaFacetVersion);
            if (!facetedProject.hasProjectFacet(JavaFacet.FACET)) {
                actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, javaFv, null));
            } else if (!facetedProject.hasProjectFacet(javaFv)) {
                actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, javaFv, null));
            }
        }

        private void removeConflictingFacets(IFacetedProject project, IProjectFacetVersion facetVersion, Set<IFacetedProject.Action> actions) {
            if (project == null) {
                throw new IllegalArgumentException("project can not be null");
            }
            if (facetVersion == null) {
                throw new IllegalArgumentException("Facet version can not be null");
            }
            if (actions == null) {
                throw new IllegalArgumentException("actions can not be null");
            }
            for (IProjectFacetVersion existingFacetVersion : project.getProjectFacets()) {
                if (!facetVersion.conflictsWith(existingFacetVersion)) continue;
                actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.UNINSTALL, existingFacetVersion, null));
            }
        }

        private String[] getDefaultWtpNatures() {
            return new String[]{"org.eclipse.wst.jsdt.core.jsNature", "org.eclipse.wst.common.project.facet.core.nature", "org.eclipse.wst.common.modulecore.ModuleCoreNature", "org.eclipse.jem.workbench.JavaEMFNature"};
        }
    }
}

