/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.operation.AddNode;
import org.apache.jackrabbit.jcr2spi.operation.AddProperty;
import org.apache.jackrabbit.jcr2spi.operation.IgnoreOperation;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.operation.TransientOperation;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.UpdatableItemStateManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;

public class SetTree
extends TransientOperation {
    private final List<Operation> operations = new ArrayList<Operation>();
    private final NodeState treeState;

    private SetTree(NodeState treeState) throws RepositoryException {
        super(0);
        this.treeState = treeState;
    }

    private SetTree(UpdatableItemStateManager itemStateMgr, NodeState parentState, Name nodeName, Name nodeTypeName, String uuid) throws RepositoryException {
        super(0);
        Operation addNode = InternalAddNode.create(parentState, nodeName, nodeTypeName, uuid);
        this.operations.add(addNode);
        itemStateMgr.execute(addNode);
        this.treeState = (NodeState)((AddNode)addNode).getAddedStates().get(0);
    }

    @Override
    public void accept(OperationVisitor visitor) throws ValueFormatException, LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        assert (this.status == 0);
        visitor.visit(this);
    }

    @Override
    public void persisted() throws RepositoryException {
        assert (this.status == 0);
        this.status = 1;
        for (Operation op : this.operations) {
            op.persisted();
        }
    }

    @Override
    public void undo() throws RepositoryException {
        assert (this.status == 0);
        this.status = 1;
        for (Operation op : this.operations) {
            op.undo();
        }
    }

    public NodeId getParentId() throws RepositoryException {
        return this.treeState.getParent().getNodeId();
    }

    public NodeState getParentState() throws RepositoryException {
        return this.treeState.getParent();
    }

    public NodeState getTreeState() throws RepositoryException {
        return this.treeState;
    }

    public Operation addChildNode(NodeState parentState, Name nodeName, Name nodeTypeName, String uuid) throws RepositoryException {
        Operation addNode = InternalAddNode.create(parentState, nodeName, nodeTypeName, uuid);
        this.operations.add(addNode);
        return addNode;
    }

    public Operation addChildProperty(NodeState parentState, Name propName, int propertyType, QValue[] values, QPropertyDefinition definition) throws RepositoryException {
        InternalAddProperty addProperty = new InternalAddProperty(parentState, propName, propertyType, values, definition);
        this.operations.add(addProperty);
        return addProperty;
    }

    public static SetTree create(NodeState treeState) throws RepositoryException {
        SetTree operation = new SetTree(treeState);
        return operation;
    }

    public static SetTree create(UpdatableItemStateManager itemStateMgr, NodeState parent, Name nodeName, Name nodeTypeName, String uuid) throws RepositoryException {
        return new SetTree(itemStateMgr, parent, nodeName, nodeTypeName, uuid);
    }

    private static final class InternalAddProperty
    extends AddProperty
    implements IgnoreOperation {
        private static final int ADD_PROPERTY_OPTIONS = 39;

        private InternalAddProperty(NodeState parentState, Name propName, int propertyType, QValue[] values, QPropertyDefinition definition) throws RepositoryException {
            super(parentState, propName, propertyType, values, definition, 39);
        }
    }

    private static final class InternalAddNode
    extends AddNode
    implements IgnoreOperation {
        private static final int ADD_NODE_OPTIONS = 39;

        private InternalAddNode(NodeState parentState, Name nodeName, Name nodeTypeName, String uuid) throws RepositoryException {
            super(parentState, nodeName, nodeTypeName, uuid, 39);
        }

        public static Operation create(NodeState parentState, Name nodeName, Name nodeTypeName, String uuid) throws RepositoryException {
            InternalAddNode.assertChildNodeEntries(parentState);
            InternalAddNode an = new InternalAddNode(parentState, nodeName, nodeTypeName, uuid);
            return an;
        }
    }
}

