/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.SerializationType;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.impl.ArtifactSetImpl;
import org.apache.jackrabbit.vault.fs.impl.io.AbstractArtifactHandler;
import org.apache.jackrabbit.vault.fs.impl.io.ImportInfoImpl;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.fs.spi.ACLManagement;
import org.apache.jackrabbit.vault.fs.spi.ServiceProviderFactory;
import org.apache.jackrabbit.vault.fs.spi.UserManagement;
import org.apache.jackrabbit.vault.util.PathUtil;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericArtifactHandler
extends AbstractArtifactHandler {
    private static final Logger log = LoggerFactory.getLogger(GenericArtifactHandler.class);
    private UserManagement userManagement = ServiceProviderFactory.getProvider().getUserManagement();
    private ACLManagement aclManagement = ServiceProviderFactory.getProvider().getACLManagement();

    @Override
    public ImportInfoImpl accept(@NotNull ImportOptions options, boolean isStrictByDefault, WorkspaceFilter wspFilter, Node parent, String name, ArtifactSetImpl artifacts) throws RepositoryException, IOException {
        Artifact primary = artifacts.getPrimaryData();
        if (primary == null) {
            return null;
        }
        ImportInfoImpl info = null;
        VaultInputSource source = primary.getInputSource();
        if (source != null && primary.getSerializationType() == SerializationType.XML_DOCVIEW) {
            info = new ImportInfoImpl();
            String path = PathUtil.getPath(parent, name);
            if ((name.length() == 0 || parent.hasNode(name)) && wspFilter.getImportMode(path) == ImportMode.MERGE) {
                Node newNode = parent.getNode(name);
                if (this.userManagement.isAuthorizableNodeType(newNode.getPrimaryNodeType().getName())) {
                    log.trace("don't skip authorizable node on MERGE: {}", (Object)path);
                } else if (this.aclManagement.isACLNode(newNode)) {
                    log.trace("don't skip policy node on MERGE: {}", (Object)path);
                } else {
                    info.onNop(path);
                    return info;
                }
            }
            info.merge(this.importDocView(source, parent, name, artifacts, options.isStrict(isStrictByDefault), wspFilter, options.getIdConflictPolicy()));
        }
        return info;
    }
}

