/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.sling.ide.impl.vlt.VltNodeDefinition;
import org.apache.sling.ide.impl.vlt.VltNodeType;
import org.apache.sling.ide.impl.vlt.VltPropertyDefinition;
import org.apache.sling.ide.impl.vlt.VltRepository;
import org.apache.sling.ide.transport.RepositoryException;
import org.apache.sling.ide.transport.RepositoryPath;
import org.apache.sling.ide.transport.ResourceProxy;
import org.apache.sling.ide.transport.Result;

public class VltNodeTypeFactory {
    private Map<String, VltNodeType> nodeTypes = new HashMap<String, VltNodeType>();

    Map<String, VltNodeType> getNodeTypes() {
        return this.nodeTypes;
    }

    public VltNodeType getNodeType(String name) {
        return this.nodeTypes.get(name);
    }

    void init(VltRepository repository) throws RepositoryException {
        Result jcrSystem = repository.newListTreeNodeCommand(new RepositoryPath("/jcr:system/jcr:nodeTypes"), 3).execute();
        for (ResourceProxy child : ((ResourceProxy)jcrSystem.get()).getChildren()) {
            VltNodeType nt = this.createNodeType(child);
            this.nodeTypes.put(nt.getName(), nt);
        }
        for (VltNodeType nt : this.nodeTypes.values()) {
            this.initDeclaredFields(nt);
        }
        for (VltNodeType nt : this.nodeTypes.values()) {
            this.initTypeDependencyTree(nt);
        }
        for (VltNodeType nt : this.nodeTypes.values()) {
            ResourceProxy child = nt.getResourceProxy();
            this.initPropertyDefinitions(nt);
            this.initProperties(nt, child);
        }
        for (VltNodeType nt : this.nodeTypes.values()) {
            this.initAllowedPrimaryChildNodeTypes(nt);
        }
    }

    private void initDeclaredFields(VltNodeType nt) {
        ResourceProxy child = nt.getResourceProxy();
        String[] superTypeNamess = (String[])child.getProperties().get("jcr:supertypes");
        nt.setDeclaredSupertypeNames(superTypeNamess);
        if (superTypeNamess != null) {
            NodeType[] superTypes = new NodeType[superTypeNamess.length];
            for (int i = 0; i < superTypeNamess.length; ++i) {
                superTypes[i] = this.getNodeType(superTypeNamess[i]);
            }
            nt.setDeclaredSupertypes(superTypes);
        }
        HashSet<VltNodeDefinition> nds = new HashSet<VltNodeDefinition>();
        for (ResourceProxy ntChild : child.getChildren()) {
            String ntChildName = ntChild.getPath().getName();
            if (ntChildName.startsWith("jcr:childNodeDefinition")) {
                VltNodeDefinition nd = this.handleChildNodeDefinition(ntChild);
                nds.add(nd);
                continue;
            }
            if (!ntChildName.startsWith("rep:residualChildNodeDefinitions")) continue;
            for (ResourceProxy residualChild : ntChild.getChildren()) {
                nds.add(this.handleChildNodeDefinition(residualChild));
            }
        }
        nt.setDeclaredChildNodeDefinitions(nds.toArray(new NodeDefinition[0]));
        this.initDeclaredPropertyDefinitions(nt, child);
    }

    private VltNodeType createNodeType(ResourceProxy child) {
        VltNodeType nt = new VltNodeType(child);
        String name = child.getPath().getName();
        nt.setName(name);
        return nt;
    }

    private void initDeclaredPropertyDefinitions(VltNodeType nt, ResourceProxy child) {
        String[] protectedProperties;
        HashMap<String, VltPropertyDefinition> pds = new HashMap<String, VltPropertyDefinition>();
        for (ResourceProxy aChild : child.getChildren()) {
            String requiredType;
            Object object;
            Boolean isProtected;
            Boolean mandatory;
            Boolean multiple;
            String jcrName;
            String childName = aChild.getPath().getName();
            if (!childName.startsWith("jcr:propertyDefinition") || (jcrName = (String)aChild.getProperties().get("jcr:name")) == null) continue;
            VltPropertyDefinition pd = new VltPropertyDefinition();
            pd.setName(jcrName);
            Boolean autoCreated = (Boolean)aChild.getProperties().get("jcr:autoCreated");
            if (autoCreated != null) {
                pd.setAutoCreated(autoCreated);
            }
            if ((multiple = (Boolean)aChild.getProperties().get("jcr:multiple")) != null) {
                pd.setMultiple(multiple);
            }
            if ((mandatory = (Boolean)aChild.getProperties().get("jcr:mandatory")) != null) {
                pd.setMandatory(mandatory);
            }
            if ((isProtected = (Boolean)aChild.getProperties().get("jcr:protected")) != null) {
                pd.setProtected(isProtected);
            }
            if ((object = aChild.getProperties().get("jcr:requiredType")) != null && (requiredType = (String)object) != null) {
                pd.setRequiredType(this.propertyTypeFromName(requiredType));
            }
            pds.put(jcrName, pd);
        }
        String[] mandatoryProperties = (String[])child.getProperties().get("rep:mandatoryProperties");
        if (mandatoryProperties != null) {
            for (int i = 0; i < mandatoryProperties.length; ++i) {
                String aMandatoryProperty = mandatoryProperties[i];
                VltPropertyDefinition vpd = (VltPropertyDefinition)pds.get(aMandatoryProperty);
                if (vpd == null) {
                    vpd = new VltPropertyDefinition();
                    vpd.setName(aMandatoryProperty);
                    pds.put(aMandatoryProperty, vpd);
                }
                vpd.setMandatory(true);
            }
        }
        if ((protectedProperties = (String[])child.getProperties().get("rep:protectedProperties")) != null) {
            for (int i = 0; i < protectedProperties.length; ++i) {
                String aProtectedProperties = protectedProperties[i];
                VltPropertyDefinition vpd = (VltPropertyDefinition)pds.get(aProtectedProperties);
                if (vpd == null) {
                    vpd = new VltPropertyDefinition();
                    vpd.setName(aProtectedProperties);
                    pds.put(aProtectedProperties, vpd);
                }
                vpd.setProtected(true);
            }
        }
        nt.setDeclaredPropertyDefinitions(pds.values().toArray(new VltPropertyDefinition[pds.size()]));
    }

    private int propertyTypeFromName(String name) {
        if (name.equalsIgnoreCase("String")) {
            return 1;
        }
        if (name.equalsIgnoreCase("Binary")) {
            return 2;
        }
        if (name.equalsIgnoreCase("Boolean")) {
            return 6;
        }
        if (name.equalsIgnoreCase("Long")) {
            return 3;
        }
        if (name.equalsIgnoreCase("Double")) {
            return 4;
        }
        if (name.equalsIgnoreCase("Decimal")) {
            return 12;
        }
        if (name.equalsIgnoreCase("Date")) {
            return 5;
        }
        if (name.equalsIgnoreCase("Name")) {
            return 7;
        }
        if (name.equalsIgnoreCase("Path")) {
            return 8;
        }
        if (name.equalsIgnoreCase("Reference")) {
            return 9;
        }
        if (name.equalsIgnoreCase("WeakReference")) {
            return 10;
        }
        if (name.equalsIgnoreCase("URI")) {
            return 11;
        }
        if (name.equalsIgnoreCase("undefined")) {
            return 0;
        }
        throw new IllegalArgumentException("unknown type: " + name);
    }

    private void initPropertyDefinitions(VltNodeType nt) {
        NodeType[] superTypes;
        HashMap<String, VltPropertyDefinition> pds = new HashMap<String, VltPropertyDefinition>();
        PropertyDefinition[] declaredPds = nt.getDeclaredPropertyDefinitions();
        if (declaredPds != null) {
            for (int i = 0; i < declaredPds.length; ++i) {
                PropertyDefinition pd = declaredPds[i];
                pds.put(pd.getName(), (VltPropertyDefinition)pd);
            }
        }
        if ((superTypes = nt.getSupertypes()) != null) {
            for (int i = 0; i < superTypes.length; ++i) {
                VltNodeType aSuperType = (VltNodeType)superTypes[i];
                VltPropertyDefinition[] superTypePds = (VltPropertyDefinition[])aSuperType.getPropertyDefinitions();
                for (int j = 0; j < superTypePds.length; ++j) {
                    VltPropertyDefinition pd = superTypePds[j];
                    VltPropertyDefinition existingPd = (VltPropertyDefinition)pds.get(pd.getName());
                    if (existingPd != null) {
                        existingPd.mergeFrom(pd);
                        continue;
                    }
                    pds.put(pd.getName(), pd);
                }
            }
        }
        nt.setPropertyDefinitions(pds.values().toArray(new VltPropertyDefinition[pds.size()]));
    }

    private void initProperties(VltNodeType nt, ResourceProxy child) {
        Boolean isMixin = (Boolean)child.getProperties().get("jcr:isMixin");
        if (isMixin == null) {
            nt.setMixin(false);
        } else {
            nt.setMixin(isMixin);
        }
    }

    private VltNodeDefinition handleChildNodeDefinition(ResourceProxy child) {
        VltNodeDefinition nd = new VltNodeDefinition();
        nd.setName((String)child.getProperties().get("jcr:name"));
        String[] requiredPrimaryTypes = (String[])child.getProperties().get("jcr:requiredPrimaryTypes");
        nd.setRequiredPrimaryTypeNames(requiredPrimaryTypes);
        if (requiredPrimaryTypes != null && requiredPrimaryTypes.length != 0) {
            NodeType[] nts = new NodeType[requiredPrimaryTypes.length];
            for (int i = 0; i < requiredPrimaryTypes.length; ++i) {
                String pt = requiredPrimaryTypes[i];
                VltNodeType nt = this.getNodeType(pt);
                nts[i] = nt;
            }
            nd.setRequiredPrimaryTypes(nts);
        }
        return nd;
    }

    private void initTypeDependencyTree(VltNodeType nt) {
        String[] superTypeNames = nt.getDeclaredSupertypeNames();
        if (superTypeNames == null) {
            return;
        }
        HashSet<NodeType> allSuperTypes = new HashSet<NodeType>();
        this.initSuperTypes(allSuperTypes, nt);
        nt.setSupertypes(allSuperTypes.toArray(new NodeType[0]));
    }

    private void initSuperTypes(Set<NodeType> allSuperTypes, VltNodeType nt) {
        NodeType[] declaredSupertypes = nt.getDeclaredSupertypes();
        if (declaredSupertypes == null) {
            return;
        }
        for (int i = 0; i < declaredSupertypes.length; ++i) {
            VltNodeType superType = (VltNodeType)declaredSupertypes[i];
            allSuperTypes.add(superType);
            nt.addSuperType(superType);
            this.initSuperTypes(allSuperTypes, superType);
        }
    }

    private void initAllowedPrimaryChildNodeTypes(VltNodeType nt0) throws RepositoryException {
        NodeDefinition[] declaredChildNodeDefinitions = nt0.getDeclaredChildNodeDefinitions();
        HashSet<String> allowedChildNodeTypes = new HashSet<String>();
        if (declaredChildNodeDefinitions != null) {
            for (int i = 0; i < declaredChildNodeDefinitions.length; ++i) {
                NodeDefinition nodeDefinition = declaredChildNodeDefinitions[i];
                NodeType[] requiredPrimaryTypes = nodeDefinition.getRequiredPrimaryTypes();
                if (requiredPrimaryTypes == null) continue;
                for (int j = 0; j < requiredPrimaryTypes.length; ++j) {
                    VltNodeType aRequiredPrimaryType = (VltNodeType)requiredPrimaryTypes[j];
                    if (aRequiredPrimaryType == null) {
                        throw new IllegalStateException("Found a required primary type with value 'null' in the array returned via 'nodeDefinition.getRequiredPrimaryTypes()' for type: " + nodeDefinition.getName());
                    }
                    Set<VltNodeType> allKnownChildTypes = aRequiredPrimaryType.getAllKnownChildTypes();
                    for (VltNodeType aChildType : allKnownChildTypes) {
                        VltNodeType nt2 = this.getNodeType(aChildType.getName());
                        if (nt2.isMixin()) continue;
                        allowedChildNodeTypes.add(nt2.getName());
                    }
                }
            }
        }
        nt0.setAllowedPrimaryChildNodeTypes(allowedChildNodeTypes);
    }
}

