/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.capabilities.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.capabilities.CapabilitiesSource;
import org.apache.sling.capabilities.internal.DuplicateNamespaceException;
import org.apache.sling.capabilities.internal.RegexFilter;

class JSONCapabilitiesWriter {
    static final String CAPS_KEY = "org.apache.sling.capabilities";
    static final String DATA_KEY = "data";

    JSONCapabilitiesWriter() {
    }

    void writeJson(ResourceResolver resolver, Writer w, Collection<CapabilitiesSource> sources, RegexFilter namespacePatterns) throws IOException {
        HashSet<String> namespaces = new HashSet<String>();
        JSONWriter jw = new JSONWriter(w);
        jw.object();
        jw.key(CAPS_KEY);
        jw.object();
        jw.key(DATA_KEY);
        jw.object();
        Map<String, Object> values = null;
        for (CapabilitiesSource s : sources) {
            String namespace = s.getNamespace();
            if (!namespacePatterns.accept(namespace)) continue;
            if (namespaces.contains(namespace)) {
                throw new DuplicateNamespaceException(namespace);
            }
            namespaces.add(namespace);
            try {
                values = s.getCapabilities(resolver);
            }
            catch (Exception e) {
                values = new HashMap<String, Object>();
                values.put("_EXCEPTION_", e.getClass().getName() + ":" + e.getMessage());
            }
            jw.key(namespace);
            jw.object();
            for (Map.Entry<String, Object> e : values.entrySet()) {
                jw.key(e.getKey());
                jw.value(e.getValue());
            }
            jw.endObject();
        }
        jw.endObject();
        jw.endObject();
        jw.endObject();
    }
}

