/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.insights.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.cms.Page;
import org.apache.sling.cms.core.insights.impl.FakeRequest;
import org.apache.sling.cms.core.insights.impl.FakeResponse;
import org.apache.sling.cms.insights.PageInsightRequest;
import org.apache.sling.engine.SlingRequestProcessor;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageInsightRequestImpl
implements PageInsightRequest {
    private static final Logger log = LoggerFactory.getLogger(PageInsightRequestImpl.class);
    private String markupCache;
    private final Page page;
    private final SlingRequestProcessor requestProcessor;
    private final ResourceResolver resourceResolver;

    public PageInsightRequestImpl(Page page, SlingRequestProcessor requestProcessor) {
        this.page = page;
        this.requestProcessor = requestProcessor;
        this.resourceResolver = page.getResource().getResourceResolver();
    }

    public Page getPage() {
        return this.page;
    }

    public Element getPageBodyElement() throws IOException {
        Document doc = this.getPageDocument();
        Elements main = doc.getElementsByTag("main");
        if (!main.isEmpty()) {
            return main.first();
        }
        return doc.body();
    }

    public String getPageBodyHtml() throws IOException {
        return this.getPageBodyElement().html();
    }

    public Document getPageDocument() throws IOException {
        return Jsoup.parse((String)this.getPageHtml());
    }

    public String getPageHtml() throws IOException {
        if (this.markupCache == null) {
            String url = this.page.getPath() + ".html";
            log.debug("Loading local page HTML from {}", (Object)url);
            FakeRequest req = new FakeRequest("GET", url);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                FakeResponse resp = new FakeResponse(out);
                this.requestProcessor.processRequest((HttpServletRequest)req, (HttpServletResponse)resp, this.resourceResolver);
            }
            catch (IOException | NoSuchAlgorithmException | ServletException e) {
                log.warn("Exception retrieving page contents for {}", (Object)url, (Object)e);
            }
            this.markupCache = new String(out.toByteArray(), StandardCharsets.UTF_8);
        }
        return this.markupCache;
    }

    public Resource getResource() {
        return this.page.getResource();
    }

    public String toString() {
        return "PageInsightRequestImpl [markupCache=" + this.markupCache + ", page=" + this.page + ", requestProcessor=" + this.requestProcessor + ", resourceResolver=" + this.resourceResolver + "]";
    }
}

