/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.jobs;

import java.io.IOException;
import java.util.Collections;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.cms.File;
import org.apache.sling.cms.FileMetadataExtractor;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={JobConsumer.class}, property={"job.topics=org/apache/sling/cms/ExtractMetadata"})
public class FileMetadataExtractorConsumer
implements JobConsumer {
    public static final Logger log = LoggerFactory.getLogger(FileMetadataExtractorConsumer.class);
    public static final String TOPIC = "org/apache/sling/cms/ExtractMetadata";
    @Reference
    private FileMetadataExtractor extractor;
    @Reference
    private ResourceResolverFactory factory;

    public JobConsumer.JobResult process(Job job) {
        block10: {
            JobConsumer.JobResult jobResult;
            block9: {
                String path = (String)job.getProperty("path", String.class);
                ResourceResolver serviceResolver = this.factory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", "sling-cms-metadata"));
                try {
                    log.debug("Processing metadata for {}", (Object)path);
                    Resource resource = serviceResolver.getResource(path);
                    File file = (File)resource.adaptTo(File.class);
                    log.debug("Retrieved file {}", (Object)file);
                    this.extractor.updateMetadata(file);
                    log.debug("Metadata extracted successfully");
                    jobResult = JobConsumer.JobResult.OK;
                    if (serviceResolver == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (serviceResolver != null) {
                            try {
                                serviceResolver.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (LoginException e) {
                        log.error("Exception getting service user", (Throwable)e);
                        break block10;
                    }
                    catch (IOException e) {
                        log.error("Failed to extract metadata from {}", (Object)path, (Object)e);
                    }
                }
                serviceResolver.close();
            }
            return jobResult;
        }
        return JobConsumer.JobResult.FAILED;
    }
}

