/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.models;

import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
@ProviderType
public class SearchResults {
    private static final Logger log = LoggerFactory.getLogger(SearchResults.class);
    private String type = "sling:Page";
    private String path = null;
    private String term = null;
    private SlingHttpServletRequest request;

    public SearchResults(SlingHttpServletRequest request) {
        if (StringUtils.isNotEmpty((CharSequence)request.getParameter("type"))) {
            this.type = request.getParameter("type");
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getParameter("path"))) {
            this.path = request.getParameter("path");
        }
        this.term = Text.escapeIllegalXpathSearchChars((String)request.getParameter("term")).replace("'", "''");
        this.request = request;
    }

    public Iterator<Resource> getResults() {
        String query = "SELECT * FROM [" + this.type + "] AS s WHERE CONTAINS(s.*, '" + this.term + "')";
        if (StringUtils.isNotEmpty((CharSequence)this.path)) {
            query = query + " AND ISDESCENDANTNODE([" + this.path + "])";
        }
        log.debug("Searching for content with {}", (Object)query);
        return this.request.getResourceResolver().findResources(query, "JCR-SQL2");
    }
}

