/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.crypto.jasypt.internal;

import java.security.Provider;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.apache.sling.commons.crypto.CryptoService;
import org.apache.sling.commons.crypto.PasswordProvider;
import org.apache.sling.commons.crypto.jasypt.internal.JasyptStandardPbeStringCryptoServiceConfiguration;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.iv.IvGenerator;
import org.jasypt.registry.AlgorithmRegistry;
import org.jasypt.salt.SaltGenerator;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Apache Sling Commons Crypto \u2013 Jasypt Standard PBE String Crypto Service", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=JasyptStandardPbeStringCryptoServiceConfiguration.class, factory=true)
public final class JasyptStandardPbeStringCryptoService
implements CryptoService {
    @Reference
    private volatile PasswordProvider passwordProvider;
    @Reference
    private volatile IvGenerator ivGenerator;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    private volatile Provider securityProvider;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    private volatile SaltGenerator saltGenerator;
    private StandardPBEStringEncryptor encryptor;
    private final Logger logger = LoggerFactory.getLogger(JasyptStandardPbeStringCryptoService.class);

    @Activate
    private void activate(JasyptStandardPbeStringCryptoServiceConfiguration configuration) {
        this.logger.debug("activating");
        this.setupEncryptor(configuration);
    }

    @Modified
    private void modified(JasyptStandardPbeStringCryptoServiceConfiguration configuration) {
        this.logger.debug("modifying");
        this.setupEncryptor(configuration);
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivating");
    }

    private void setupEncryptor(JasyptStandardPbeStringCryptoServiceConfiguration configuration) {
        SaltGenerator saltGenerator;
        Provider provider;
        String algorithm = configuration.algorithm();
        Set algorithms = AlgorithmRegistry.getAllPBEAlgorithms();
        if (!algorithms.contains(algorithm)) {
            this.logger.warn("Configured algorithm {} for password based encryption is not available. {}", (Object)algorithm, (Object)algorithms);
        }
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setAlgorithm(algorithm);
        IvGenerator ivGenerator = this.ivGenerator;
        encryptor.setIvGenerator(ivGenerator);
        encryptor.setKeyObtentionIterations(configuration.keyObtentionIterations());
        encryptor.setStringOutputType(configuration.stringOutputType());
        String securityProviderName = configuration.securityProviderName();
        if (Objects.nonNull(securityProviderName) && !securityProviderName.isBlank()) {
            encryptor.setProviderName(securityProviderName);
        }
        if (Objects.nonNull(provider = this.securityProvider)) {
            encryptor.setProvider(provider);
        }
        if (Objects.nonNull(saltGenerator = this.saltGenerator)) {
            encryptor.setSaltGenerator(saltGenerator);
        }
        char[] password = this.passwordProvider.getPassword();
        encryptor.setPasswordCharArray(password);
        encryptor.initialize();
        Arrays.fill(password, '0');
        this.encryptor = encryptor;
    }

    @Override
    @NotNull
    public String encrypt(@NotNull String message) {
        return this.encryptor.encrypt(message);
    }

    @Override
    @NotNull
    public String decrypt(@NotNull String ciphertext) {
        return this.encryptor.decrypt(ciphertext);
    }
}

