/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.fsclassloader.impl;

import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class ScriptFiles {
    private final String classFile;
    private final String depsFile;
    private final String javaFile;
    private final String script;

    public static String getScript(File root, File file) {
        String relative = file.getAbsolutePath().substring(root.getAbsolutePath().length());
        String script = ScriptFiles.remove(relative, "/org/apache/jsp");
        script = ScriptFiles.remove(script, ".class");
        script = ScriptFiles.remove(script, ".java");
        script = ScriptFiles.remove(script, ".deps");
        if (File.separatorChar == '\\') {
            script = script.replace(File.separatorChar, '/');
        }
        return StringUtils.substringBeforeLast((String)script, (String)"_") + "." + StringUtils.substringAfterLast((String)script, (String)"_");
    }

    private static String remove(String orig, String rem) {
        return orig.replace(rem, "");
    }

    public ScriptFiles(File root, File file) {
        this.script = ScriptFiles.getScript(root, file);
        String relative = file.getAbsolutePath().substring(root.getAbsolutePath().length());
        relative = ScriptFiles.remove(relative, ".class");
        relative = ScriptFiles.remove(relative, ".deps");
        relative = ScriptFiles.remove(relative, ".java");
        this.classFile = relative + ".class";
        this.depsFile = relative + ".deps";
        this.javaFile = relative + ".java";
    }

    public String getClassFile() {
        return this.classFile;
    }

    public String getDepsFile() {
        return this.depsFile;
    }

    public String getJavaFile() {
        return this.javaFile;
    }

    public String getScript() {
        return this.script;
    }
}

