/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggerContextAwareBase;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.joran.spi.ConfigurationWatchList;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelUtil;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.spi.ConfigurationEvent;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusListenerAsList;
import ch.qos.logback.core.status.StatusUtil;
import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.apache.sling.commons.log.logback.internal.AppenderOrigin;
import org.apache.sling.commons.log.logback.internal.AppenderTracker;
import org.apache.sling.commons.log.logback.internal.ConfigResetRequestHandler;
import org.apache.sling.commons.log.logback.internal.ConfigSourceTracker;
import org.apache.sling.commons.log.logback.internal.FilterTracker;
import org.apache.sling.commons.log.logback.internal.LevelChangePropagatorChecker;
import org.apache.sling.commons.log.logback.internal.LogConfig;
import org.apache.sling.commons.log.logback.internal.LogWriter;
import org.apache.sling.commons.log.logback.internal.LogbackResetListener;
import org.apache.sling.commons.log.logback.internal.MaskingMessageUtil;
import org.apache.sling.commons.log.logback.internal.OsgiIntegrationListener;
import org.apache.sling.commons.log.logback.internal.RootLoggerListener;
import org.apache.sling.commons.log.logback.internal.SlingConfigurationPrinter;
import org.apache.sling.commons.log.logback.internal.SlingLogPanel;
import org.apache.sling.commons.log.logback.internal.TurboFilterTracker;
import org.apache.sling.commons.log.logback.internal.config.ConfigAdminSupport;
import org.apache.sling.commons.log.logback.internal.config.ConfigurationException;
import org.apache.sling.commons.log.logback.internal.joran.JoranConfiguratorWrapper;
import org.apache.sling.commons.log.logback.internal.stacktrace.OSGiAwareExceptionHandling;
import org.apache.sling.commons.log.logback.internal.stacktrace.PackageInfoCollector;
import org.apache.sling.commons.log.logback.internal.util.LoggerSpecificEncoder;
import org.apache.sling.commons.log.logback.internal.util.SlingRollingFileAppender;
import org.apache.sling.commons.log.logback.internal.util.SlingStatusPrinter;
import org.apache.sling.commons.log.logback.spi.DefaultConfigurator;
import org.apache.sling.commons.log.logback.webconsole.LogPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.util.converter.Converter;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class LogConfigManager
extends LoggerContextAwareBase
implements LogbackResetListener,
LogConfig.LogWriterProvider {
    private static final String CONTEXT_NAME = "sling";
    private BundleContext bundleContext;
    private final LoggerContext loggerContext;
    private final Map<String, LogWriter> writerByPid;
    private final Map<String, LogWriter> writerByFileName;
    private Map<AppenderOrigin, Map<String, Set<String>>> appendersByOrigin = new ConcurrentHashMap<AppenderOrigin, Map<String, Set<String>>>();
    private final Map<String, LogConfig> configByPid;
    private final Map<String, LogConfig> configByCategory;
    private File rootDir;
    private Dictionary<String, String> defaultConfiguration;
    private final ConfigAdminSupport configAdminSupport;
    private final org.slf4j.Logger logger;
    private File logbackConfigFile;
    private boolean packagingDataEnabled;
    private int maxCallerDataDepth;
    private int maxOldFileCount;
    private int numOfLines;
    private final List<LogbackResetListener> resetListeners = new ArrayList<LogbackResetListener>();
    private final LoggerContextListener osgiIntegrationListener;
    private final boolean debug;
    private boolean started;
    private final Semaphore resetLock = new Semaphore(1);
    private final Object configChangedFlagLock = new Object();
    private boolean configChanged = false;
    private AppenderTracker appenderTracker;
    private ConfigSourceTracker configSourceTracker;
    private FilterTracker filterTracker;
    private TurboFilterTracker turboFilterTracker;
    private final List<ServiceRegistration<?>> registrations = new ArrayList();
    private final List<ServiceTracker<?, ?>> serviceTrackers = new ArrayList();
    boolean bridgeHandlerInstalled = false;
    private final PackageInfoCollector packageInfoCollector = new PackageInfoCollector();
    volatile long resetStartTime;
    private Converter converter;

    public void internalFailure(@NotNull String message, @Nullable Throwable t) {
        if (t != null) {
            this.addError(message, t);
        } else {
            this.addError(message);
        }
        System.err.println(message);
        if (t != null) {
            t.printStackTrace();
        }
    }

    public LogConfigManager(@NotNull BundleContext context) {
        this.bundleContext = context;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.debug = Boolean.parseBoolean(this.bundleContext.getProperty("org.apache.sling.commons.log.debug"));
        this.converter = Converters.standardConverter();
        this.loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.loggerContext.setName(CONTEXT_NAME);
        this.setLoggerContext(this.loggerContext);
        this.writerByPid = new ConcurrentHashMap<String, LogWriter>();
        this.writerByFileName = new ConcurrentHashMap<String, LogWriter>();
        this.configByPid = new ConcurrentHashMap<String, LogConfig>();
        this.configByCategory = new ConcurrentHashMap<String, LogConfig>();
        this.getRootDir();
        this.osgiIntegrationListener = new OsgiIntegrationListener(this);
        this.configAdminSupport = new ConfigAdminSupport();
    }

    public void start() {
        this.setDefaultConfiguration(this.getBundleConfiguration(this.bundleContext));
        this.bridgeHandlerInstalled = this.maybeInstallSlf4jBridgeHandler(this.bundleContext);
        this.configAdminSupport.start(this.bundleContext, this);
        this.resetListeners.add(new LevelChangePropagatorChecker(() -> this.bridgeHandlerInstalled));
        this.resetListeners.add(this);
        try {
            this.appenderTracker = new AppenderTracker(this.bundleContext, this);
            this.appenderTracker.open(true);
            this.serviceTrackers.add(this.appenderTracker);
            this.resetListeners.add(this.appenderTracker);
        }
        catch (InvalidSyntaxException e) {
            this.logger.error("Failed to open the appender tracker", e);
        }
        try {
            this.configSourceTracker = new ConfigSourceTracker(this.bundleContext, this);
            this.configSourceTracker.open(true);
            this.serviceTrackers.add(this.configSourceTracker);
            this.resetListeners.add(this.configSourceTracker);
        }
        catch (InvalidSyntaxException e) {
            this.logger.error("Failed to open the config source tracker", e);
        }
        try {
            this.filterTracker = new FilterTracker(this.bundleContext, this);
            this.filterTracker.open(true);
            this.serviceTrackers.add(this.filterTracker);
            this.resetListeners.add(this.filterTracker);
        }
        catch (InvalidSyntaxException e) {
            this.logger.error("Failed to open the filter tracker", e);
        }
        this.turboFilterTracker = new TurboFilterTracker(this.bundleContext);
        this.turboFilterTracker.open(true);
        this.serviceTrackers.add(this.turboFilterTracker);
        this.resetListeners.add(this.turboFilterTracker);
        this.resetListeners.add(new RootLoggerListener());
        this.loggerContext.addListener(this.osgiIntegrationListener);
        this.registerWebConsoleSupport();
        this.registerEventHandler();
        this.addInfo("LogbackManager: BEGIN initial configuration");
        this.failSafeConfigure();
        this.addInfo("LogbackManager: END initialconfiguration");
        this.started = true;
        this.checkForNewConfigsWhileStarting(this.loggerContext);
    }

    public void stop() {
        this.started = false;
        this.loggerContext.removeListener(this.osgiIntegrationListener);
        this.configAdminSupport.stop();
        for (ServiceTracker<?, ?> serviceTracker : this.serviceTrackers) {
            serviceTracker.close();
        }
        this.serviceTrackers.clear();
        this.appenderTracker = null;
        this.configSourceTracker = null;
        this.filterTracker = null;
        this.turboFilterTracker = null;
        for (ServiceRegistration serviceRegistration : this.registrations) {
            serviceRegistration.unregister();
        }
        this.registrations.clear();
        if (this.bridgeHandlerInstalled) {
            SLF4JBridgeHandler.uninstall();
            this.bridgeHandlerInstalled = false;
        }
        this.clearAllAppenders();
        this.writerByPid.clear();
        this.writerByFileName.clear();
        this.configByPid.clear();
        this.configByCategory.clear();
        this.loggerContext.reset();
        DefaultConfigurator defaultConfigurator = new DefaultConfigurator();
        defaultConfigurator.setContext(this.loggerContext);
        defaultConfigurator.configure(this.loggerContext);
    }

    @Nullable
    public AppenderTracker getAppenderTracker() {
        return this.appenderTracker;
    }

    @Nullable
    public ConfigSourceTracker getConfigSourceTracker() {
        return this.configSourceTracker;
    }

    private void clearAllAppenders() {
        for (Map.Entry<AppenderOrigin, Map<String, Set<String>>> entry : this.appendersByOrigin.entrySet()) {
            this.clearAppenders(entry.getKey(), entry.getValue());
        }
        this.appendersByOrigin.clear();
    }

    private void clearAppenders(@NotNull AppenderOrigin origin, @NotNull Map<String, Set<String>> map) {
        HashMap<String, Set<String>> tempMap = new HashMap<String, Set<String>>(map);
        for (Map.Entry entry : tempMap.entrySet()) {
            String[] copyOfValue;
            String appenderName = (String)entry.getKey();
            for (String loggerName : copyOfValue = (String[])((Set)entry.getValue()).toArray(String[]::new)) {
                this.maybeDetachAppender(origin, appenderName, (Logger)LoggerFactory.getLogger(loggerName));
            }
        }
        map.clear();
    }

    private boolean maybeInstallSlf4jBridgeHandler(@NotNull BundleContext bundleContext) {
        boolean julSupport = (Boolean)((Converting)this.converter.convert((Object)bundleContext.getProperty("org.apache.sling.commons.log.julenabled")).defaultValue((Object)false)).to(Boolean.TYPE);
        if (julSupport) {
            if (!this.isClassNameVisible("org.slf4j.bridge.SLF4JBridgeHandler")) {
                this.logger.warn("Failed to re-configure the SLF4JBridgeHandler since that class was not found. Check if the jul-to-slf4j bundle is deployed.");
            } else if (!SLF4JBridgeHandler.isInstalled()) {
                if (System.getProperty("java.util.logging.config.file") == null && System.getProperty("java.util.logging.config.class") == null) {
                    LogManager.getLogManager().reset();
                    this.logger.debug("The JUL logging configuration was reset to empty");
                } else {
                    this.logger.debug("The JUL logging configuration was not reset to empty as JUL config system properties were set");
                }
                SLF4JBridgeHandler.removeHandlersForRootLogger();
                SLF4JBridgeHandler.install();
                java.util.logging.Logger.getLogger("").setLevel(Level.FINEST);
            } else {
                this.logger.debug("Failed to re-confiugre JUL as the SLF4JBridgeHandle was already installed elsewhere");
            }
        }
        return julSupport;
    }

    public URL getDefaultConfigURL() {
        return this.getClass().getResource("/logback-empty.xml");
    }

    @Nullable
    private LogConfig getDefaultConfig() {
        return this.configByPid.get("org.apache.sling.commons.log.LogManager");
    }

    @NotNull
    private Layout<ILoggingEvent> getDefaultLayout() {
        return this.getDefaultConfig().createLayout(this.loggerContext);
    }

    @NotNull
    public Appender<ILoggingEvent> getDefaultAppender() {
        ConsoleAppender<ILoggingEvent> appender = new ConsoleAppender<ILoggingEvent>();
        appender.setName("org.apache.sling.commons.log.CONSOLE");
        appender.setContext(this.loggerContext);
        appender.setEncoder(MaskingMessageUtil.getDefaultEncoder(this.loggerContext));
        ((OutputStreamAppender)appender).start();
        return appender;
    }

    @Override
    public void onResetStart(@NotNull LoggerContext context) {
        this.clearAllAppenders();
    }

    @Override
    public void onResetComplete(@NotNull LoggerContext context) {
        HashMap<String, Appender<ILoggingEvent>> appendersByName = new HashMap<String, Appender<ILoggingEvent>>();
        HashMap<String, Appender<ILoggingEvent>> configuredAppenders = new HashMap<String, Appender<ILoggingEvent>>();
        configuredAppenders.putAll(this.getKnownAppenders(AppenderOrigin.JORAN));
        configuredAppenders.putAll(this.getKnownAppenders(AppenderOrigin.JORAN_OSGI));
        HashMap<Appender<ILoggingEvent>, LoggerSpecificEncoder> encoders = new HashMap<Appender<ILoggingEvent>, LoggerSpecificEncoder>();
        HashSet<String> configPids = new HashSet<String>();
        for (LogConfig config : this.getLogConfigs()) {
            configPids.add(config.getConfigPid());
            Appender<ILoggingEvent> appender = null;
            if (config.isAppenderDefined()) {
                LogWriter lw = config.getLogWriter();
                String appenderName = lw.getAppenderName();
                appender = (Appender<ILoggingEvent>)appendersByName.get(appenderName);
                if (appender == null && (appender = (Appender)configuredAppenders.get(appenderName)) != null) {
                    this.addInfo(String.format("Found overriding configuration for appender %s in Logback config. OSGi config would be ignored", appenderName));
                }
                if (appender == null) {
                    LoggerSpecificEncoder encoder = new LoggerSpecificEncoder(this.getDefaultLayout());
                    appender = lw.createAppender(this.loggerContext, encoder);
                    encoders.put(appender, encoder);
                    appendersByName.put(appenderName, appender);
                }
                if (encoders.containsKey(appender)) {
                    ((LoggerSpecificEncoder)encoders.get(appender)).addLogConfig(config);
                }
            }
            for (String category : config.getCategories()) {
                Logger targetLogger = this.loggerContext.getLogger(category);
                if (config.isResetToDefault()) {
                    targetLogger.setLevel(null);
                    targetLogger.setAdditive(true);
                    continue;
                }
                targetLogger.setLevel(config.getLogLevel());
                if (appender == null) continue;
                targetLogger.setAdditive(config.isAdditive());
                targetLogger.addAppender(appender);
                this.addInfo(String.format("Registering appender %s(%s) with logger %s", appender.getName(), appender.getClass(), targetLogger.getName()));
            }
            if (appender == null) continue;
            this.addedAppenderRef(AppenderOrigin.CONFIGSERVICE, appender.getName(), config.getCategories());
        }
        context.putObject("org.apache.sling.commons.log.ConfigPids", configPids);
    }

    public void setDefaultConfiguration(@NotNull Dictionary<String, String> defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
        try {
            this.updateGlobalConfiguration(defaultConfiguration);
        }
        catch (ConfigurationException ce) {
            this.internalFailure("Unexpected Configuration Problem", ce);
        }
    }

    @NotNull
    protected Dictionary<String, String> getBundleConfiguration(@NotNull BundleContext bundleContext) {
        String[] props;
        Hashtable<String, String> config = new Hashtable<String, String>();
        for (String prop : props = new String[]{"org.apache.sling.commons.log.level", "org.apache.sling.commons.log.file", "org.apache.sling.commons.log.file.number", "org.apache.sling.commons.log.file.size", "org.apache.sling.commons.log.pattern", "org.apache.sling.commons.log.configurationFile", "org.apache.sling.commons.log.packagingDataEnabled"}) {
            String value = bundleContext.getProperty(prop);
            if (value == null) continue;
            ((Dictionary)config).put(prop, value);
        }
        return config;
    }

    @NotNull
    protected String getAbsoluteFilePath(@NotNull String logFileName) {
        File logFile = new File(logFileName = logFileName.replace('/', File.separatorChar));
        if (!logFile.isAbsolute()) {
            logFile = Paths.get(this.rootDir.toURI()).resolve(logFileName).toFile();
            logFileName = logFile.getAbsolutePath();
        }
        return logFileName;
    }

    protected boolean isLogbackFileValid(@NotNull File file) {
        boolean valid = false;
        if (!file.exists()) {
            this.logger.warn("Logback configuration file [{}] does not exist", (Object)file.getAbsolutePath());
        } else if (!file.isFile()) {
            this.logger.warn("Logback configuration file [{}] is not a file", (Object)file.getAbsolutePath());
        } else if (!file.canRead()) {
            this.logger.warn("Logback configuration file [{}] cannot be read", (Object)file.getAbsolutePath());
        } else {
            valid = true;
        }
        return valid;
    }

    private void processGlobalConfig(@NotNull Dictionary<String, String> configuration) {
        File file;
        String fileName = (String)((Converting)this.converter.convert((Object)configuration.get("org.apache.sling.commons.log.configurationFile")).defaultValue((Object)"")).to(String.class);
        if (!fileName.isEmpty() && this.isLogbackFileValid(file = new File(this.getAbsoluteFilePath(fileName)))) {
            this.logbackConfigFile = file;
        }
        this.packagingDataEnabled = (Boolean)((Converting)this.converter.convert((Object)configuration.get("org.apache.sling.commons.log.packagingDataEnabled")).defaultValue((Object)false)).to(Boolean.TYPE);
        this.maxCallerDataDepth = (Integer)((Converting)this.converter.convert((Object)configuration.get("org.apache.sling.commons.log.maxCallerDataDepth")).defaultValue((Object)8)).to(Integer.TYPE);
        this.maxOldFileCount = (Integer)((Converting)this.converter.convert((Object)configuration.get("org.apache.sling.commons.log.maxOldFileCountInDump")).defaultValue((Object)3)).to(Integer.TYPE);
        this.numOfLines = (Integer)((Converting)this.converter.convert((Object)configuration.get("org.apache.sling.commons.log.numOfLines")).defaultValue((Object)1000)).to(Integer.TYPE);
    }

    public void updateGlobalConfiguration(@Nullable Dictionary<String, String> configuration) throws ConfigurationException {
        this.logger.info("updating global configuration for {}", (Object)"org.apache.sling.commons.log.LogManager");
        if (configuration == null) {
            configuration = this.defaultConfiguration;
        }
        this.processGlobalConfig(configuration);
        configuration.put("org.apache.sling.commons.log.names", "ROOT");
        String logFile = configuration.get("org.apache.sling.commons.log.file");
        if (logFile == null || logFile.trim().length() == 0) {
            configuration.put("org.apache.sling.commons.log.file", "CONSOLE");
        }
        this.updateLogWriter("org.apache.sling.commons.log.LogManager", configuration, false);
        this.updateLoggerConfiguration("org.apache.sling.commons.log.LogManager", configuration, false);
        this.configChanged();
    }

    public void updateLogWriter(@NotNull String pid, @Nullable Dictionary<?, ?> configuration, boolean performRefresh) throws ConfigurationException {
        if (configuration != null) {
            LogWriter existingWriterByFileName;
            LogWriter oldWriter = this.writerByPid.get(pid);
            String logFileName = (String)configuration.get("org.apache.sling.commons.log.file");
            if (logFileName == null || logFileName.trim().isEmpty()) {
                logFileName = "CONSOLE";
            }
            if (!"CONSOLE".equals(logFileName) && (existingWriterByFileName = this.writerByFileName.get(logFileName = this.getAbsoluteFilePath(logFileName))) != null && !existingWriterByFileName.getConfigurationPID().equals(pid)) {
                throw new ConfigurationException("org.apache.sling.commons.log.file", "LogFile " + logFileName + " already configured by configuration " + existingWriterByFileName.getConfigurationPID());
            }
            Object fileNumProp = configuration.get("org.apache.sling.commons.log.file.number");
            int fileNum = -1;
            if (fileNumProp instanceof Number) {
                fileNum = ((Number)fileNumProp).intValue();
            } else if (fileNumProp != null) {
                try {
                    fileNum = Integer.parseInt(fileNumProp.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            Object fileSizeProp = configuration.get("org.apache.sling.commons.log.file.size");
            String fileSize = null;
            if (fileSizeProp != null) {
                fileSize = fileSizeProp.toString();
            }
            boolean bufferedLogging = (Boolean)((Converting)this.converter.convert(configuration.get("org.apache.sling.commons.log.file.buffered")).defaultValue((Object)false)).to(Boolean.TYPE);
            LogWriter newWriter = new LogWriter(pid, this.getAppenderName(logFileName), fileNum, fileSize, logFileName, bufferedLogging);
            if (oldWriter != null) {
                this.writerByFileName.remove(oldWriter.getFileName());
            }
            this.writerByFileName.put(newWriter.getFileName(), newWriter);
            this.writerByPid.put(newWriter.getConfigurationPID(), newWriter);
        } else {
            LogWriter logWriter = this.writerByPid.remove(pid);
            if (logWriter != null) {
                this.writerByFileName.remove(logWriter.getFileName());
            }
        }
        if (performRefresh) {
            this.configChanged();
        }
    }

    public void updateLoggerConfiguration(@NotNull String pid, @Nullable Dictionary<?, ?> configuration, boolean performRefresh) throws ConfigurationException {
        if (configuration != null) {
            LogConfig oldConfig;
            Set categories;
            ch.qos.logback.classic.Level logLevel;
            boolean resetToDefault;
            String pattern = (String)((Converting)this.converter.convert(configuration.get("org.apache.sling.commons.log.pattern")).defaultValue((Object)"%d{dd.MM.yyyy HH:mm:ss.SSS} *%level* [%thread] %logger %msg%n")).to(String.class);
            String level = (String)((Converting)this.converter.convert(configuration.get("org.apache.sling.commons.log.level")).defaultValue((Object)"INFO")).to(String.class);
            if ("DEFAULT".equalsIgnoreCase(level)) {
                resetToDefault = true;
                logLevel = null;
            } else {
                logLevel = ch.qos.logback.classic.Level.toLevel(level, null);
                if (logLevel == null) {
                    throw new ConfigurationException("org.apache.sling.commons.log.level", "Not a valid value");
                }
                resetToDefault = false;
            }
            String fileName = (String)((Converting)this.converter.convert(configuration.get("org.apache.sling.commons.log.file")).defaultValue(null)).to(String.class);
            if (fileName != null && fileName.trim().isEmpty()) {
                fileName = "CONSOLE";
            }
            if (fileName != null && !"CONSOLE".equals(fileName)) {
                fileName = this.getAbsoluteFilePath(fileName);
            }
            if ((categories = (Set)this.converter.convert(configuration.get("org.apache.sling.commons.log.names")).to(Set.class)).isEmpty()) {
                throw new ConfigurationException("org.apache.sling.commons.log.names", "Missing categories in configuration " + pid);
            }
            boolean additiv = (Boolean)((Converting)this.converter.convert(configuration.get("org.apache.sling.commons.log.additiv")).defaultValue((Object)false)).to(Boolean.TYPE);
            for (String cat : categories) {
                LogConfig cfg = this.configByCategory.get(cat);
                if (cfg == null || pid.equals(cfg.getConfigPid())) continue;
                throw new ConfigurationException("org.apache.sling.commons.log.names", String.format("Category %s already defined by configuration %s", cat, cfg.getConfigPid()));
            }
            LogConfig newConfig = new LogConfig(this, pattern, categories, logLevel, fileName, additiv, pid, resetToDefault);
            if (this.packagingDataEnabled) {
                newConfig.setPostProcessor(new OSGiAwareExceptionHandling(this.getPackageInfoCollector()));
            }
            if ((oldConfig = this.configByPid.get(pid)) != null) {
                this.configByCategory.keySet().removeAll(oldConfig.getCategories());
            }
            for (String cat : categories) {
                this.configByCategory.put(cat, newConfig);
            }
            this.configByPid.put(pid, newConfig);
        } else {
            LogConfig config = this.configByPid.remove(pid);
            if (config != null) {
                this.configByCategory.keySet().removeAll(config.getCategories());
            }
        }
        if (performRefresh) {
            this.configChanged();
        }
    }

    public void checkForNewConfigsWhileStarting(@NotNull LoggerContext context) {
        Set configPids = (Set)context.getObject("org.apache.sling.commons.log.ConfigPids");
        if (configPids == null) {
            this.addWarn("Did not find any configPid set");
            return;
        }
        if (!configPids.equals(this.configByPid.keySet())) {
            this.addInfo("Config change detected post start. Scheduling config reload");
            this.configChanged();
        } else {
            this.addInfo("Configured the Logback with " + configPids.size() + " configs");
        }
    }

    public boolean isPackagingDataEnabled() {
        return this.packagingDataEnabled;
    }

    public int getMaxCallerDataDepth() {
        return this.maxCallerDataDepth;
    }

    public int getMaxOldFileCount() {
        return this.maxOldFileCount;
    }

    public int getNumOfLines() {
        return this.numOfLines;
    }

    protected void addOrUpdateAppender(@NotNull AppenderOrigin origin, @NotNull String appenderName, @NotNull Appender<ILoggingEvent> appender, @NotNull Collection<String> loggers) {
        Logger targetLogger;
        Map appenderNameToLoggerNamesMap = this.appendersByOrigin.getOrDefault((Object)origin, Collections.emptyMap());
        HashSet loggerNamesSet = new HashSet(appenderNameToLoggerNamesMap.getOrDefault(appenderName, Collections.emptySet()));
        for (String loggerName : loggerNamesSet) {
            targetLogger = (Logger)LoggerFactory.getLogger(loggerName);
            this.maybeDetachAppender(origin, appenderName, targetLogger);
        }
        appender.setContext(this.loggerContext);
        appender.setName(appenderName);
        appender.start();
        for (String loggerName : loggers) {
            targetLogger = (Logger)LoggerFactory.getLogger(loggerName);
            this.addInfo(String.format("attaching appender %s for %s", appenderName, targetLogger.getName()));
            targetLogger.addAppender(appender);
        }
        this.addedAppenderRef(origin, appenderName, loggers);
    }

    protected void addOrUpdateAppender(@NotNull AppenderOrigin origin, @NotNull String appenderName, @NotNull Dictionary<String, ?> config) {
        String[] loggers;
        ConsoleAppender<ILoggingEvent> appender;
        Map appenderNameToLoggerNamesMap = this.appendersByOrigin.getOrDefault((Object)origin, Collections.emptyMap());
        HashSet loggerNamesSet = new HashSet(appenderNameToLoggerNamesMap.getOrDefault(appenderName, Collections.emptySet()));
        for (String loggerName : loggerNamesSet) {
            Logger targetLogger = (Logger)LoggerFactory.getLogger(loggerName);
            this.maybeDetachAppender(origin, appenderName, targetLogger);
        }
        String pattern = (String)((Converting)this.converter.convert(config.get("org.apache.sling.commons.log.pattern")).defaultValue((Object)"%d{dd.MM.yyyy HH:mm:ss.SSS} *%level* [%thread] %logger %msg%n")).to(String.class);
        PatternLayoutEncoder ple = new PatternLayoutEncoder();
        ple.setPattern(pattern);
        ple.setContext(this.loggerContext);
        ple.start();
        String file = (String)((Converting)this.converter.convert(config.get("org.apache.sling.commons.log.file")).defaultValue((Object)"")).to(String.class);
        if (file.isEmpty() || "CONSOLE".equals(file)) {
            appender = new ConsoleAppender<ILoggingEvent>();
        } else {
            file = this.getAbsoluteFilePath(file);
            RollingFileAppender fileAppender = new RollingFileAppender();
            fileAppender.setFile(file);
            fileAppender.setAppend(true);
            String fileNamePattern = LogWriter.createFileNamePattern(file, (String)((Converting)this.converter.convert(config.get("org.apache.sling.commons.log.file.size")).defaultValue((Object)"'.'yyyy-MM-dd")).to(String.class));
            fileNamePattern = this.getAbsoluteFilePath(fileNamePattern);
            TimeBasedRollingPolicy rollingPolicy = new TimeBasedRollingPolicy();
            rollingPolicy.setContext(this.loggerContext);
            rollingPolicy.setParent(fileAppender);
            rollingPolicy.setFileNamePattern(fileNamePattern);
            int fileNumber = (Integer)((Converting)this.converter.convert(config.get("org.apache.sling.commons.log.file.number")).defaultValue((Object)5)).to(Integer.TYPE);
            rollingPolicy.setMaxHistory(fileNumber);
            rollingPolicy.start();
            fileAppender.setRollingPolicy(rollingPolicy);
            appender = fileAppender;
        }
        appender.setName(appenderName);
        appender.setEncoder(ple);
        appender.setContext(this.loggerContext);
        ((OutputStreamAppender)appender).start();
        ch.qos.logback.classic.Level level = ch.qos.logback.classic.Level.valueOf((String)((Converting)this.converter.convert(config.get("org.apache.sling.commons.log.level")).defaultValue((Object)"INFO")).to(String.class));
        boolean additive = (Boolean)((Converting)this.converter.convert(config.get("org.apache.sling.commons.log.additiv")).defaultValue((Object)false)).to(Boolean.TYPE);
        for (String loggerName : loggers = (String[])((Converting)this.converter.convert(config.get("org.apache.sling.commons.log.names")).defaultValue((Object)"ROOT")).to(String[].class)) {
            Logger targetLogger = (Logger)LoggerFactory.getLogger(loggerName);
            this.addInfo(String.format("attaching appender %s for %s", appenderName, targetLogger.getName()));
            targetLogger.setLevel(level);
            targetLogger.setAdditive(additive);
            targetLogger.addAppender((Appender<ILoggingEvent>)appender);
        }
        this.addedAppenderRef(origin, appenderName, List.of(loggers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maybeDetachAppender(@NotNull AppenderOrigin origin, @NotNull String appenderName, @NotNull Logger targetLogger) {
        Appender<ILoggingEvent> appender = targetLogger.getAppender(appenderName);
        if (appender != null) {
            String loggerName = targetLogger.getName();
            this.addInfo(String.format("detaching appender %s for %s", appenderName, loggerName));
            targetLogger.detachAppender(appenderName);
            if (this.filterTracker != null) {
                this.filterTracker.detachedAppender(appender);
            }
            Map<AppenderOrigin, Map<String, Set<String>>> map = this.appendersByOrigin;
            synchronized (map) {
                Map map2 = this.appendersByOrigin.getOrDefault((Object)origin, Collections.emptyMap());
                Set loggerNamesSet = (Set)map2.get(appenderName);
                if (loggerNamesSet != null) {
                    loggerNamesSet.remove(loggerName);
                    if (loggerNamesSet.isEmpty()) {
                        map2.remove(appenderName);
                    }
                }
            }
        }
    }

    @NotNull
    Map<String, Appender<ILoggingEvent>> getAllKnownAppenders() {
        HashMap<String, Appender<ILoggingEvent>> all = new HashMap<String, Appender<ILoggingEvent>>();
        for (AppenderOrigin origin : this.appendersByOrigin.keySet()) {
            all.putAll(this.getKnownAppenders(origin));
        }
        return Collections.unmodifiableMap(all);
    }

    @NotNull
    Map<String, Appender<ILoggingEvent>> getKnownAppenders(@NotNull AppenderOrigin origin) {
        HashMap<String, Appender> appendersMap = new HashMap<String, Appender>();
        Map map = this.appendersByOrigin.getOrDefault((Object)origin, Collections.emptyMap());
        for (Map.Entry entry : map.entrySet()) {
            String pid = (String)entry.getKey();
            appendersMap.computeIfAbsent(pid, k -> this.firstAppenderFromLoggers(pid, (Collection)entry.getValue()));
        }
        return Collections.unmodifiableMap(appendersMap);
    }

    @NotNull
    public Set<String> getLoggerNamesForKnownAppender(@NotNull AppenderOrigin origin, @NotNull String appenderName) {
        Map map = this.appendersByOrigin.getOrDefault((Object)origin, Collections.emptyMap());
        return map.getOrDefault(appenderName, Collections.emptySet());
    }

    @Nullable
    Appender<ILoggingEvent> firstAppenderFromLoggers(@NotNull String name, @NotNull Collection<String> loggerNames) {
        String loggerName;
        Logger targetLogger;
        Appender<ILoggingEvent> appender = null;
        Iterator<String> iterator = loggerNames.iterator();
        while (iterator.hasNext() && (appender = (targetLogger = (Logger)LoggerFactory.getLogger(loggerName = iterator.next())).getAppender(name)) == null) {
        }
        return appender;
    }

    public void addedAppenderRef(@NotNull AppenderOrigin origin, @NotNull String appenderName, @NotNull String loggerName) {
        this.addedAppenderRef(origin, appenderName, List.of(loggerName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addedAppenderRef(@NotNull AppenderOrigin origin, @NotNull String appenderName, @NotNull Collection<String> loggerNames) {
        Appender<ILoggingEvent> appender;
        Map<AppenderOrigin, Map<String, Set<String>>> map = this.appendersByOrigin;
        synchronized (map) {
            Map appenderNameToLoggerNamesMap = this.appendersByOrigin.computeIfAbsent(origin, k -> new HashMap());
            Set set = appenderNameToLoggerNamesMap.computeIfAbsent(appenderName, k -> new HashSet());
            set.addAll(loggerNames);
        }
        if (this.filterTracker != null && (appender = this.firstAppenderFromLoggers(appenderName, loggerNames)) != null) {
            this.filterTracker.attachedAppender(appender);
        }
    }

    public void addSubsitutionProperties(@NotNull PropertyContainer propContainer) {
        propContainer.addSubstitutionProperty("sling.home", this.rootDir.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configChanged() {
        if (!this.started) {
            this.logger.debug("LoggerContext is not started so skipping reset handling");
            return;
        }
        Object object = this.configChangedFlagLock;
        synchronized (object) {
            if (this.resetLock.tryAcquire()) {
                this.configChanged = false;
                this.scheduleConfigReload();
            } else {
                this.configChanged = true;
                this.addInfo("LoggerContext reset in progress. Marking config changed to true");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean rescheduleIfConfigChanged() {
        boolean rescheduled = false;
        Object object = this.configChangedFlagLock;
        synchronized (object) {
            if (this.configChanged && this.resetLock.tryAcquire()) {
                this.configChanged = false;
                this.scheduleConfigReload();
                rescheduled = true;
            }
        }
        return rescheduled;
    }

    @NotNull
    protected Future scheduleConfigReload() {
        return this.loggerContext.getExecutorService().submit(() -> {
            try {
                this.failSafeConfigure();
            }
            finally {
                this.resetLock.release();
                this.addInfo("Re configuration done");
                this.rescheduleIfConfigChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void failSafeConfigure() {
        try {
            this.addInfo("Performing configuration");
            long startTime = System.currentTimeMillis();
            StatusListener statusListener = new StatusListenerAsList(){

                @Override
                public boolean isResetResistant() {
                    return true;
                }
            };
            if (this.debug) {
                OnConsoleStatusListener onConsoleStatusListener = new OnConsoleStatusListener();
                onConsoleStatusListener.setResetResistant(true);
                statusListener = onConsoleStatusListener;
            }
            this.getStatusManager().add(statusListener);
            this.addInfo("Resetting context: " + this.getLoggerContext().getName());
            JoranConfiguratorWrapper configurator = new JoranConfiguratorWrapper(this);
            configurator.setContext(this.loggerContext);
            Model failsafeTop = configurator.recallSafeConfiguration();
            this.loggerContext.reset();
            long threshold = System.currentTimeMillis();
            boolean success = false;
            try {
                if (this.logbackConfigFile != null) {
                    configurator.doConfigure(this.logbackConfigFile);
                } else {
                    configurator.doConfigure(this.getDefaultConfigURL());
                }
                StatusUtil statusUtil = new StatusUtil(this.loggerContext);
                if (!statusUtil.hasXMLParsingErrors(threshold)) {
                    this.addInfo("Context: " + this.getLoggerContext().getName() + " reloaded.");
                    success = true;
                }
            }
            catch (Throwable t) {
                this.addError("Error occurred while configuring Logback", t);
            }
            finally {
                if (!success) {
                    this.fallbackConfiguration(this.loggerContext, failsafeTop);
                }
                this.getStatusManager().remove(statusListener);
                SlingStatusPrinter.printInCaseOfErrorsOrWarnings(this.loggerContext, this.resetStartTime, startTime, success);
            }
            this.fireResetCompleteListeners();
        }
        catch (Exception e) {
            this.logger.warn("Error occurred while re-configuring logger", e);
            this.addError("Error occurred while re-configuring logger", e);
        }
    }

    private void fallbackConfiguration(LoggerContext lc, Model failsafeTop) {
        JoranConfiguratorWrapper joranConfigurator = new JoranConfiguratorWrapper(this);
        joranConfigurator.setContext(this.context);
        ConfigurationWatchList oldCWL = ConfigurationWatchListUtil.getConfigurationWatchList(this.context);
        ConfigurationWatchList newCWL = oldCWL.buildClone();
        if (failsafeTop == null) {
            this.addWarn("No previous configuration to fall back on.");
        } else {
            this.addWarn("Given previous errors, falling back to previously registered safe configuration.");
            this.addInfo("Safe model " + String.valueOf(failsafeTop));
            try {
                lc.reset();
                ConfigurationWatchListUtil.registerConfigurationWatchList(this.context, newCWL);
                ModelUtil.resetForReuse(failsafeTop);
                joranConfigurator.processModel(failsafeTop);
                this.addInfo("Re-registering previous fallback configuration once more as a fallback configuration point");
                joranConfigurator.registerSafeConfiguration(failsafeTop);
                this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationEndedSuccessfullyEvent(this));
                this.addInfo("after registerSafeConfiguration");
            }
            catch (Exception e) {
                this.addError("Unexpected exception thrown by a configuration considered safe.", e);
            }
        }
    }

    String getRootDir() {
        if (this.rootDir == null) {
            String slingLogRoot = this.bundleContext.getProperty("sling.log.root");
            if (slingLogRoot == null && (slingLogRoot = this.bundleContext.getProperty("sling.home")) == null) {
                slingLogRoot = Paths.get("", new String[0]).toAbsolutePath().toString();
            }
            this.addInfo("Using rootDir as " + slingLogRoot);
            this.rootDir = new File(slingLogRoot);
        }
        return this.rootDir.toString();
    }

    void updateResetStartTime() {
        this.resetStartTime = System.currentTimeMillis() + TimeUnit.MILLISECONDS.toMillis(1L);
    }

    public void fireResetStartListeners() {
        for (LogbackResetListener listener : this.resetListeners) {
            this.addInfo("Firing reset listener - onResetStart " + String.valueOf(listener.getClass()));
            listener.onResetStart(this.loggerContext);
        }
    }

    public void fireResetCompleteListeners() {
        for (LogbackResetListener listener : this.resetListeners) {
            this.addInfo("Firing reset listener - onResetComplete " + String.valueOf(listener.getClass()));
            listener.onResetComplete(this.loggerContext);
        }
    }

    @NotNull
    public PackageInfoCollector getPackageInfoCollector() {
        return this.packageInfoCollector;
    }

    @NotNull
    private String getAppenderName(@NotNull String filePathAbsolute) {
        String rootDirPath = this.rootDir.getAbsolutePath();
        if (filePathAbsolute.startsWith(rootDirPath)) {
            return filePathAbsolute.substring(rootDirPath.length()).replace('\\', '/');
        }
        return filePathAbsolute;
    }

    @NotNull
    private LogWriter createImplicitWriter(@NotNull String logWriterName) {
        LogWriter defaultWriter = this.getDefaultWriter();
        if (defaultWriter == null) {
            throw new IllegalStateException("Default logger configuration must have been configured by now");
        }
        return new LogWriter(this.getAppenderName(logWriterName), logWriterName, defaultWriter.getLogNumber(), defaultWriter.getLogRotation());
    }

    @Nullable
    public LogWriter getDefaultWriter() {
        return this.writerByPid.get("org.apache.sling.commons.log.LogManager");
    }

    public boolean hasWriterByPid(String pid) {
        return this.writerByPid.containsKey(pid);
    }

    public boolean hasWriterByName(String logWriterName) {
        return this.writerByFileName.containsKey(logWriterName);
    }

    boolean hasConfigByPid(String pid) {
        return this.configByPid.containsKey(pid);
    }

    boolean hasConfigByName(String loggerName) {
        return this.configByCategory.containsKey(loggerName);
    }

    @Override
    @NotNull
    public LogWriter getLogWriter(@NotNull String logWriterName) {
        LogWriter lw = this.writerByFileName.get(logWriterName);
        if (lw == null) {
            lw = this.createImplicitWriter(logWriterName);
        }
        return lw;
    }

    public File getLogbackConfigFile() {
        return this.logbackConfigFile;
    }

    public Iterable<LogConfig> getLogConfigs() {
        return this.configByPid.values();
    }

    public LoggerStateContext determineLoggerState() {
        List<Logger> loggers = this.loggerContext.getLoggerList();
        LoggerStateContext ctx = new LoggerStateContext(loggers, this.packageInfoCollector);
        for (LogConfig lc : this.getLogConfigs()) {
            for (String category : lc.getCategories()) {
                ctx.osgiConfiguredLoggers.put(category, lc);
            }
        }
        for (Logger targetLogger : loggers) {
            boolean configuredViaOSGiConfig;
            boolean hasOnlySlingRollingAppenders = true;
            Iterator<Appender<ILoggingEvent>> itr = targetLogger.iteratorForAppenders();
            while (itr.hasNext()) {
                Appender<ILoggingEvent> a = itr.next();
                if (a.getName() != null && !ctx.appenders.containsKey(a.getName())) {
                    ctx.appenders.put(a.getName(), a);
                }
                if (a instanceof SlingRollingFileAppender) continue;
                hasOnlySlingRollingAppenders = false;
            }
            if (targetLogger.getLevel() == null || (configuredViaOSGiConfig = ctx.osgiConfiguredLoggers.containsKey(targetLogger.getName())) && hasOnlySlingRollingAppenders) continue;
            ctx.nonOSgiConfiguredLoggers.add(targetLogger);
        }
        return ctx;
    }

    private void registerWebConsoleSupport() {
        Hashtable<String, String> panelProps = new Hashtable<String, String>();
        ((Dictionary)panelProps).put("service.vendor", "Apache Software Foundation");
        ((Dictionary)panelProps).put("service.description", "Sling Log Panel Support");
        this.registrations.add(this.bundleContext.registerService(LogPanel.class.getName(), (Object)new SlingLogPanel(this, this.bundleContext), panelProps));
        Hashtable<String, String> printerProps = new Hashtable<String, String>();
        ((Dictionary)printerProps).put("service.vendor", "Apache Software Foundation");
        ((Dictionary)printerProps).put("service.description", "Sling Log Configuration Printer");
        ((Dictionary)printerProps).put("felix.webconsole.label", "slinglogs");
        ((Dictionary)printerProps).put("felix.webconsole.title", "Log Files");
        ((Dictionary)printerProps).put("felix.webconsole.configprinter.modes", "always");
        this.registrations.add(this.bundleContext.registerService(SlingConfigurationPrinter.class, (Object)new SlingConfigurationPrinter(this), printerProps));
    }

    private void registerEventHandler() {
        String className = "org.osgi.service.event.EventHandler";
        if (this.isClassNameVisible(className)) {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("service.vendor", "Apache Software Foundation");
            ((Dictionary)props).put("service.description", "Sling Log Reset Event Handler");
            ((Dictionary)props).put("event.topics", new String[]{"org/apache/sling/commons/log/RESET"});
            this.registrations.add(this.bundleContext.registerService(className, (Object)new ConfigResetRequestHandler(this), props));
        } else {
            this.logger.warn("Failed to register the config reset event handler since the event handler class was not found. Check if the eventadmin bundle is deployed.");
        }
    }

    boolean isClassNameVisible(String className) {
        boolean visible;
        try {
            this.getClass().getClassLoader().loadClass(className);
            visible = true;
        }
        catch (ClassNotFoundException e) {
            visible = false;
        }
        return visible;
    }

    void registerPackageInfoCollector() {
        if (this.packagingDataEnabled) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("service.vendor", "Apache Software Foundation");
            ((Dictionary)props).put("service.description", "Sling Log Package Info Collector");
            this.registrations.add(this.bundleContext.registerService(WeavingHook.class.getName(), (Object)this.packageInfoCollector, props));
        }
    }

    public class LoggerStateContext {
        final List<Logger> allLoggers;
        final List<Logger> nonOSgiConfiguredLoggers = new ArrayList<Logger>();
        final Map<String, LogConfig> osgiConfiguredLoggers = new HashMap<String, LogConfig>();
        final Map<String, Appender<ILoggingEvent>> appenders = new HashMap<String, Appender<ILoggingEvent>>();
        final Map<Appender<ILoggingEvent>, AppenderTracker.AppenderInfo> dynamicAppenders = new HashMap<Appender<ILoggingEvent>, AppenderTracker.AppenderInfo>();
        final Map<ServiceReference<TurboFilter>, TurboFilter> turboFilters;
        final PackageInfoCollector packageInfoCollector;

        LoggerStateContext(List<Logger> allLoggers, PackageInfoCollector packageInfoCollector) {
            this.allLoggers = allLoggers;
            this.packageInfoCollector = packageInfoCollector;
            if (LogConfigManager.this.appenderTracker != null) {
                for (AppenderTracker.AppenderInfo ai : LogConfigManager.this.appenderTracker.getAppenderInfos()) {
                    this.dynamicAppenders.put(ai.appender, ai);
                }
            }
            this.turboFilters = LogConfigManager.this.turboFilterTracker == null ? Collections.emptyMap() : LogConfigManager.this.turboFilterTracker.getFilters();
        }

        int getNumberOfLoggers() {
            return this.allLoggers.size();
        }

        int getNumOfDynamicAppenders() {
            return LogConfigManager.this.appenderTracker.getAppenderInfos().size();
        }

        int getNumOfAppenders() {
            return this.appenders.size();
        }

        boolean isDynamicAppender(Appender<ILoggingEvent> a) {
            return this.dynamicAppenders.containsKey(a);
        }

        ServiceReference<TurboFilter> getTurboFilterRef(TurboFilter tf) {
            for (Map.Entry<ServiceReference<TurboFilter>, TurboFilter> e : this.turboFilters.entrySet()) {
                if (!e.getValue().equals(tf)) continue;
                return e.getKey();
            }
            return null;
        }

        Collection<Appender<ILoggingEvent>> getAllAppenders() {
            return this.appenders.values();
        }

        Map<String, Appender<ILoggingEvent>> getAppenderMap() {
            return Collections.unmodifiableMap(this.appenders);
        }
    }
}

