/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.datasource.internal;

import java.lang.management.ManagementFactory;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.datasource.internal.DriverDataSource;
import org.apache.sling.datasource.internal.DriverRegistry;
import org.apache.tomcat.jdbc.pool.ConnectionPool;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.sling.datasource.DataSourceFactory", label="%datasource.component.name", description="%datasource.component.description", metatype=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
public class DataSourceFactory {
    public static final String NAME = "org.apache.sling.datasource.DataSourceFactory";
    @Property
    static final String PROP_DATASOURCE_NAME = "datasource.name";
    @Property(value={"datasource.name"})
    static final String PROP_DS_SVC_PROP_NAME = "datasource.svc.prop.name";
    @Property
    static final String PROP_DRIVERCLASSNAME = "driverClassName";
    @Property
    static final String PROP_URL = "url";
    @Property
    static final String PROP_USERNAME = "username";
    @Property(passwordValue={""})
    static final String PROP_PASSWORD = "password";
    static final String DEFAULT_VAL = "default";
    @Property(value={"default"}, options={@PropertyOption(name="Default", value="default"), @PropertyOption(name="true", value="true"), @PropertyOption(name="false", value="false")})
    static final String PROP_DEFAULTAUTOCOMMIT = "defaultAutoCommit";
    @Property(value={"default"}, options={@PropertyOption(name="Default", value="default"), @PropertyOption(name="true", value="true"), @PropertyOption(name="false", value="false")})
    static final String PROP_DEFAULTREADONLY = "defaultReadOnly";
    @Property(value={"default"}, options={@PropertyOption(name="Default", value="default"), @PropertyOption(name="NONE", value="NONE"), @PropertyOption(name="READ_COMMITTED", value="READ_COMMITTED"), @PropertyOption(name="READ_UNCOMMITTED", value="READ_UNCOMMITTED"), @PropertyOption(name="REPEATABLE_READ", value="REPEATABLE_READ"), @PropertyOption(name="SERIALIZABLE", value="SERIALIZABLE")})
    static final String PROP_DEFAULTTRANSACTIONISOLATION = "defaultTransactionIsolation";
    @Property
    static final String PROP_DEFAULTCATALOG = "defaultCatalog";
    @Property(intValue={100})
    static final String PROP_MAXACTIVE = "maxActive";
    @Property(intValue={100})
    static final String PROP_MAXIDLE = "maxIdle";
    @Property(intValue={10})
    static final String PROP_MINIDLE = "minIdle";
    @Property(intValue={10})
    static final String PROP_INITIALSIZE = "initialSize";
    @Property(intValue={30000})
    static final String PROP_MAXWAIT = "maxWait";
    @Property(intValue={0})
    static final String PROP_MAXAGE = "maxAge";
    @Property(boolValue={false})
    static final String PROP_TESTONBORROW = "testOnBorrow";
    @Property(boolValue={false})
    static final String PROP_TESTONRETURN = "testOnReturn";
    @Property(boolValue={false})
    static final String PROP_TESTWHILEIDLE = "testWhileIdle";
    @Property
    static final String PROP_VALIDATIONQUERY = "validationQuery";
    @Property(intValue={-1})
    static final String PROP_VALIDATIONQUERY_TIMEOUT = "validationQueryTimeout";
    @Property(intValue={5000})
    protected static final String PROP_TIMEBETWEENEVICTIONRUNSMILLIS = "timeBetweenEvictionRunsMillis";
    @Property(intValue={60000})
    protected static final String PROP_MINEVICTABLEIDLETIMEMILLIS = "minEvictableIdleTimeMillis";
    @Property
    protected static final String PROP_CONNECTIONPROPERTIES = "connectionProperties";
    @Property
    protected static final String PROP_INITSQL = "initSQL";
    @Property(value={"StatementCache;SlowQueryReport(threshold=10000);ConnectionState"})
    protected static final String PROP_INTERCEPTORS = "jdbcInterceptors";
    @Property(intValue={30000})
    protected static final String PROP_VALIDATIONINTERVAL = "validationInterval";
    @Property(boolValue={true})
    protected static final String PROP_LOGVALIDATIONERRORS = "logValidationErrors";
    @Property(value={}, cardinality=1024)
    static final String PROP_DATASOURCE_SVC_PROPS = "datasource.svc.properties";
    private static final Set<String> PROPS_WITH_DFEAULT = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("defaultAutoCommit", "defaultReadOnly", "defaultTransactionIsolation")));
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private DriverRegistry driverRegistry;
    private String name;
    private String svcPropName;
    private ObjectName jmxName;
    private ServiceRegistration dsRegistration;
    private DataSource dataSource;
    private BundleContext bundleContext;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, ?> config) throws Exception {
        this.bundleContext = bundleContext;
        this.name = DataSourceFactory.getDataSourceName(config);
        DataSourceFactory.checkArgument(this.name != null, "DataSource name must be specified via [%s] property", PROP_DATASOURCE_NAME);
        this.dataSource = new LazyJmxRegisteringDataSource(this.createPoolConfig(config));
        this.svcPropName = DataSourceFactory.getSvcPropName(config);
        this.registerDataSource(this.svcPropName);
        this.log.info("Created DataSource [{}] with properties {}", (Object)this.name, (Object)this.dataSource.getPoolProperties().toString());
    }

    @Modified
    protected void modified(Map<String, ?> config) throws Exception {
        String name = DataSourceFactory.getDataSourceName(config);
        String svcPropName = DataSourceFactory.getSvcPropName(config);
        if (!this.name.equals(name) || !this.svcPropName.equals(svcPropName)) {
            this.log.info("Change in datasource name/service property name detected. DataSource would be recreated");
            this.deactivate();
            this.activate(this.bundleContext, config);
            return;
        }
        this.dataSource.setPoolProperties(this.createPoolConfig(config));
        this.closeConnectionPool();
        this.dataSource.createPool();
        this.log.info("Updated DataSource [{}] with properties {}", (Object)name, (Object)this.dataSource.getPoolProperties().toString());
    }

    @Deactivate
    protected void deactivate() {
        if (this.dsRegistration != null) {
            this.dsRegistration.unregister();
            this.dsRegistration = null;
        }
        this.closeConnectionPool();
        this.dataSource = null;
    }

    private void closeConnectionPool() {
        this.unregisterJmx();
        this.dataSource.close();
    }

    private PoolConfiguration createPoolConfig(Map<String, ?> config) {
        Properties props = new Properties();
        Map<String, String> otherProps = PropertiesUtil.toMap(config.get(PROP_DATASOURCE_SVC_PROPS), new String[0]);
        for (Map.Entry<String, String> e : otherProps.entrySet()) {
            DataSourceFactory.set(e.getKey(), e.getValue(), props);
        }
        props.setProperty("object_name", this.name);
        for (String propName : DummyDataSourceFactory.getPropertyNames()) {
            String value = PropertiesUtil.toString(config.get(propName), null);
            DataSourceFactory.set(propName, value, props);
        }
        PoolConfiguration poolProperties = org.apache.tomcat.jdbc.pool.DataSourceFactory.parsePoolProperties(props);
        poolProperties.setDataSource(this.createDriverDataSource(poolProperties));
        return poolProperties;
    }

    private DriverDataSource createDriverDataSource(PoolConfiguration poolProperties) {
        return new DriverDataSource(poolProperties, this.driverRegistry, this.bundleContext, this);
    }

    private void registerDataSource(String svcPropName) {
        Hashtable<String, String> svcProps = new Hashtable<String, String>();
        ((Dictionary)svcProps).put(svcPropName, this.name);
        ((Dictionary)svcProps).put("service.vendor", "Apache Software Foundation");
        ((Dictionary)svcProps).put("service.description", "DataSource service based on Tomcat JDBC");
        this.dsRegistration = this.bundleContext.registerService(javax.sql.DataSource.class, (Object)this.dataSource, svcProps);
    }

    private void registerJmx(ConnectionPool pool) throws SQLException {
        org.apache.tomcat.jdbc.pool.jmx.ConnectionPool jmxPool = pool.getJmxPool();
        if (jmxPool == null) {
            return;
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("type", "ConnectionPool");
        table.put("class", javax.sql.DataSource.class.getName());
        table.put("name", ObjectName.quote(this.name));
        try {
            this.jmxName = new ObjectName("org.apache.sling", table);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(jmxPool, this.jmxName);
        }
        catch (Exception e) {
            this.log.warn("Error occurred while registering the JMX Bean for connection pool with name {}", (Object)this.jmxName, (Object)e);
        }
    }

    ConnectionPool getPool() {
        return this.dataSource.getPool();
    }

    private void unregisterJmx() {
        try {
            if (this.jmxName != null) {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                mbs.unregisterMBean(this.jmxName);
            }
        }
        catch (InstanceNotFoundException mbs) {
        }
        catch (Exception e) {
            this.log.error("Unable to unregister JDBC pool with JMX", (Throwable)e);
        }
    }

    static String getDataSourceName(Map<String, ?> config) {
        return PropertiesUtil.toString(config.get(PROP_DATASOURCE_NAME), null);
    }

    static String getSvcPropName(Map<String, ?> config) {
        return PropertiesUtil.toString(config.get(PROP_DS_SVC_PROP_NAME), PROP_DATASOURCE_NAME);
    }

    private static void set(String name, String value, Properties props) {
        if (PROPS_WITH_DFEAULT.contains(name) && DEFAULT_VAL.equals(value)) {
            value = null;
        }
        if (value != null) {
            value = value.trim();
        }
        if (value != null && !value.isEmpty()) {
            props.setProperty(name, value);
        }
    }

    static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    protected void bindDriverRegistry(DriverRegistry driverRegistry) {
        this.driverRegistry = driverRegistry;
    }

    protected void unbindDriverRegistry(DriverRegistry driverRegistry) {
        if (this.driverRegistry == driverRegistry) {
            this.driverRegistry = null;
        }
    }

    private static class DummyDataSourceFactory
    extends org.apache.tomcat.jdbc.pool.DataSourceFactory {
        private DummyDataSourceFactory() {
        }

        static String[] getPropertyNames() {
            return ALL_PROPERTIES;
        }
    }

    private class LazyJmxRegisteringDataSource
    extends DataSource {
        private volatile boolean initialized;

        public LazyJmxRegisteringDataSource(PoolConfiguration poolProperties) {
            super(poolProperties);
        }

        @Override
        public ConnectionPool createPool() throws SQLException {
            ConnectionPool pool = super.createPool();
            this.registerJmxLazily(pool);
            return pool;
        }

        @Override
        public void close() {
            this.initialized = false;
            super.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerJmxLazily(ConnectionPool pool) throws SQLException {
            if (!this.initialized) {
                LazyJmxRegisteringDataSource lazyJmxRegisteringDataSource = this;
                synchronized (lazyJmxRegisteringDataSource) {
                    if (this.initialized) {
                        return;
                    }
                    DataSourceFactory.this.registerJmx(pool);
                    this.initialized = true;
                }
            }
        }
    }
}

