/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.helper;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import javax.servlet.ServletRequest;
import org.apache.felix.http.javaxwrappers.ServletContextWrapper;
import org.apache.sling.api.request.SlingJakartaRequestEvent;
import org.apache.sling.api.request.SlingJakartaRequestListener;
import org.apache.sling.api.request.SlingRequestEvent;
import org.apache.sling.api.request.SlingRequestListener;
import org.apache.sling.api.wrappers.JakartaToJavaxRequestWrapper;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.FieldOption;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.component.propertytypes.ServiceVendor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RequestListenerManager.class})
@ServiceDescription(value="Request listener manager")
@ServiceVendor(value="The Apache Software Foundation")
public class RequestListenerManager {
    private final ServletContext servletContext;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, fieldOption=FieldOption.REPLACE)
    private volatile List<SlingRequestListener> listeners;
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, fieldOption=FieldOption.REPLACE)
    private volatile List<SlingJakartaRequestListener> jakartaListeners;

    @Activate
    public RequestListenerManager(@Reference(target="(name=org.apache.sling)") ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void sendEvent(HttpServletRequest request, SlingJakartaRequestEvent.EventType type) {
        List<SlingRequestListener> localDep;
        List<SlingJakartaRequestListener> local = this.jakartaListeners;
        if (local != null && !local.isEmpty()) {
            SlingJakartaRequestEvent event = new SlingJakartaRequestEvent(this.servletContext, (jakarta.servlet.ServletRequest)request, type);
            for (SlingJakartaRequestListener service : local) {
                try {
                    service.onEvent(event);
                }
                catch (Throwable t) {
                    this.logger.error("Error invoking sling request listener " + String.valueOf(service) + " : " + t.getMessage(), t);
                }
            }
        }
        if ((localDep = this.listeners) != null && !localDep.isEmpty()) {
            SlingRequestEvent.EventType eventType = type == SlingJakartaRequestEvent.EventType.EVENT_INIT ? SlingRequestEvent.EventType.EVENT_INIT : SlingRequestEvent.EventType.EVENT_DESTROY;
            SlingRequestEvent event = new SlingRequestEvent((javax.servlet.ServletContext)new ServletContextWrapper(this.servletContext), (ServletRequest)JakartaToJavaxRequestWrapper.toJavaxRequest((HttpServletRequest)request), eventType);
            for (SlingRequestListener service : localDep) {
                try {
                    service.onEvent(event);
                }
                catch (Throwable t) {
                    this.logger.error("Error invoking sling request listener " + String.valueOf(service) + " : " + t.getMessage(), t);
                }
            }
        }
    }
}

