/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.scanner.ContentPackageDescriptor;

public class CheckContentPackageForInstallables
implements AnalyserTask {
    static final String CFG_CHECK_PACKAGES = "embedded-packages";

    @Override
    public String getName() {
        return "Content Packages Installable Check";
    }

    @Override
    public String getId() {
        return "content-packages-installables";
    }

    @Override
    public void execute(AnalyserTaskContext ctx) throws Exception {
        boolean checkPcks = Boolean.parseBoolean(ctx.getConfiguration().getOrDefault(CFG_CHECK_PACKAGES, "false"));
        for (ContentPackageDescriptor cp : ctx.getFeatureDescriptor().getDescriptors(ContentPackageDescriptor.class)) {
            if (cp.getArtifactFile() == null) {
                ctx.reportArtifactError(cp.getArtifact().getId(), "Content package " + cp.getName() + " is not resolved and can not be checked.");
                continue;
            }
            if (checkPcks && cp.isEmbeddedInContentPackage()) {
                ctx.reportArtifactError(cp.getParentContentPackage().getArtifact().getId(), "Content package " + cp.getParentContentPackage().getArtifact().getId() + " embedds content package " + cp.getName());
            }
            if (!cp.hasEmbeddedArtifacts() || cp.isEmbeddedInContentPackage()) continue;
            ctx.reportArtifactError(cp.getArtifact().getId(), "Content package " + cp.getName() + " contains " + String.valueOf(cp.getBundles().size()) + " bundles and " + String.valueOf(cp.getConfigurations().size()) + " configurations.");
        }
    }
}

