/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.cache;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.ops4j.peaberry.AttributeFilter;
import org.ops4j.peaberry.Import;
import org.ops4j.peaberry.cache.AbstractServiceListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FilteredIterableService<T>
implements Iterable<Import<T>> {
    final AbstractServiceListener<T> listener;
    final AttributeFilter filter;

    FilteredIterableService(AbstractServiceListener<T> listener, AttributeFilter filter) {
        this.listener = listener;
        this.filter = filter;
    }

    @Override
    public Iterator<Import<T>> iterator() {
        return new Iterator<Import<T>>(){
            private Import<T> prevImport;
            private Import<T> nextImport;

            @Override
            public boolean hasNext() {
                return null != this.findNextImport();
            }

            @Override
            public Import<T> next() {
                if (null == this.findNextImport()) {
                    throw new NoSuchElementException();
                }
                this.prevImport = this.nextImport;
                this.nextImport = null;
                return this.prevImport;
            }

            private Import<T> findNextImport() {
                Import tempImport;
                if (null == this.nextImport && null != (tempImport = FilteredIterableService.this.listener.findNextImport(this.prevImport, FilteredIterableService.this.filter))) {
                    this.prevImport = null;
                    this.nextImport = tempImport;
                }
                return this.nextImport;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof FilteredIterableService) {
            FilteredIterableService iterable = (FilteredIterableService)rhs;
            return this.listener.equals(iterable.listener) && FilteredIterableService.equals(this.filter, iterable.filter);
        }
        return false;
    }

    public int hashCode() {
        return this.listener.hashCode() ^ (null == this.filter ? 0 : this.filter.hashCode());
    }

    private static boolean equals(Object lhs, Object rhs) {
        return null == lhs ? null == rhs : lhs.equals(rhs);
    }
}

