/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.cache;

import java.util.Map;
import org.ops4j.peaberry.AttributeFilter;
import org.ops4j.peaberry.Export;
import org.ops4j.peaberry.Import;
import org.ops4j.peaberry.ServiceWatcher;
import org.ops4j.peaberry.util.SimpleExport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilteredServiceWatcher<S>
implements ServiceWatcher<S> {
    final AttributeFilter filter;
    final ServiceWatcher<S> watcher;

    public FilteredServiceWatcher(AttributeFilter filter, ServiceWatcher<S> watcher) {
        this.filter = filter;
        this.watcher = watcher;
    }

    @Override
    public <T extends S> Export<T> add(Import<T> service) {
        return new FilteredExport<T>(service);
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof FilteredServiceWatcher) {
            FilteredServiceWatcher filteredWatcher = (FilteredServiceWatcher)rhs;
            return this.filter.equals(filteredWatcher.filter) && this.watcher.equals(filteredWatcher.watcher);
        }
        return false;
    }

    public int hashCode() {
        return this.filter.hashCode() ^ this.watcher.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FilteredExport<T extends S>
    extends SimpleExport<T> {
        private Export<T> realExport;

        FilteredExport(Import<T> service) {
            super(service);
            this.checkMatchingService();
        }

        private void checkMatchingService() {
            if (FilteredServiceWatcher.this.filter.matches(super.attributes())) {
                if (null == this.realExport) {
                    this.realExport = FilteredServiceWatcher.this.watcher.add(this);
                }
            } else if (null != this.realExport) {
                Export<T> temp = this.realExport;
                this.realExport = null;
                temp.unput();
            }
        }

        @Override
        public synchronized void put(T newInstance) {
            super.put(newInstance);
            if (null != this.realExport) {
                this.realExport.put(newInstance);
            }
        }

        @Override
        public synchronized void attributes(Map<String, ?> newAttributes) {
            super.attributes(newAttributes);
            if (null != this.realExport) {
                this.realExport.attributes(newAttributes);
            }
            this.checkMatchingService();
        }
    }
}

