/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl.ipeconfig;

import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentManager;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.format.MediaFormatHandler;
import io.wcm.handler.media.impl.ipeconfig.AspectRatioResource;
import io.wcm.handler.media.impl.ipeconfig.CroppingRatios;
import io.wcm.handler.media.impl.ipeconfig.OverlayResource;
import io.wcm.handler.media.impl.ipeconfig.PathParser;
import io.wcm.sling.commons.adapter.AdaptTo;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@org.osgi.service.component.annotations.Component(service={ResourceProvider.class}, property={"provider.name=wcmioHandlerIPEConfig", "provider.root=/wcmio:mediaHandler/ipeConfig"})
public class IPEConfigResourceProvider
extends ResourceProvider {
    public static final String IPECONFIG_OVERLAY_ROOTPATH = "/wcmio:mediaHandler/ipeConfig";

    @Nullable
    public Resource getResource(@NotNull ResolveContext resolveContext, @NotNull String path, @NotNull ResourceContext resourceContext, @Nullable Resource parent) {
        PathParser parser = new PathParser(path);
        if (!parser.isValid()) {
            return null;
        }
        ResourceResolver resolver = resolveContext.getResourceResolver();
        if (parser.isAspectRatiosNode()) {
            return this.buildAspectRatiosResource(resolver, path);
        }
        if (parser.isAspectRatioItem()) {
            String mediaFormatName = parser.getAspectRatioItemName();
            if (parser.getMediaFormatNames().contains(mediaFormatName)) {
                return this.buildAspectRatioItemResource(resolver, path, mediaFormatName, parser);
            }
        } else {
            Resource overlayResource;
            String overlayResourcePath = this.getIpeConfigPath(resolver, parser);
            if (StringUtils.isNotEmpty((CharSequence)overlayResourcePath) && (overlayResource = resolver.getResource(overlayResourcePath)) != null) {
                return new OverlayResource(overlayResource, path);
            }
        }
        return null;
    }

    @Nullable
    public Iterator<Resource> listChildren(@NotNull ResolveContext resolveContext, @NotNull Resource resource) {
        Map<String, Resource> childMap = this.getOverlayedResourceChilden(resource);
        String path = resource.getPath();
        PathParser parser = new PathParser(path);
        if (!parser.isValid()) {
            return null;
        }
        ResourceResolver resolver = resolveContext.getResourceResolver();
        if (parser.isPluginsCropNode()) {
            childMap.put("aspectRatios", this.buildAspectRatiosResource(resolver, path + "/" + "aspectRatios"));
        } else if (parser.isAspectRatiosNode()) {
            childMap.clear();
            for (String mediaFormatName : parser.getMediaFormatNames()) {
                Resource item = this.buildAspectRatioItemResource(resolver, path + "/" + mediaFormatName, mediaFormatName, parser);
                if (item == null) continue;
                childMap.put(mediaFormatName, item);
            }
        }
        if (childMap.isEmpty()) {
            return null;
        }
        return childMap.values().iterator();
    }

    private Map<String, Resource> getOverlayedResourceChilden(Resource resource) {
        LinkedHashMap<String, Resource> childMap = new LinkedHashMap<String, Resource>();
        if (resource instanceof OverlayResource) {
            Resource overlayResource = ((OverlayResource)resource).getOverlayedResource();
            Iterator childrenIterator = overlayResource.listChildren();
            while (childrenIterator.hasNext()) {
                Resource child = (Resource)childrenIterator.next();
                childMap.put(child.getName(), (Resource)new OverlayResource(child, resource.getPath() + "/" + child.getName()));
            }
        }
        return childMap;
    }

    private Resource buildAspectRatiosResource(ResourceResolver resolver, String path) {
        return new SyntheticResource(resolver, path, null);
    }

    private Resource buildAspectRatioItemResource(ResourceResolver resolver, String path, String mediaFormatName, PathParser parser) {
        MediaFormatHandler mediaFormatHandler;
        MediaFormat mediaFormat;
        Resource componentContent = resolver.getResource(parser.getComponentContentPath());
        if (componentContent != null && (mediaFormat = this.getMediaFormat(mediaFormatName, mediaFormatHandler = (MediaFormatHandler)AdaptTo.notNull((Adaptable)componentContent, MediaFormatHandler.class))) != null) {
            return new AspectRatioResource(resolver, mediaFormat, path);
        }
        return null;
    }

    private MediaFormat getMediaFormat(String mediaFormatName, MediaFormatHandler mediaFormatHandler) {
        if (StringUtils.equals((CharSequence)mediaFormatName, (CharSequence)CroppingRatios.MEDIAFORMAT_FREE_CROP.getName())) {
            return CroppingRatios.MEDIAFORMAT_FREE_CROP;
        }
        return mediaFormatHandler.getMediaFormat(mediaFormatName);
    }

    private String getIpeConfigPath(ResourceResolver resolver, PathParser parser) {
        String ipeConfigPath;
        ComponentManager componentManager;
        Component component;
        Resource componentContent = resolver.getResource(parser.getComponentContentPath());
        if (componentContent != null && (component = (componentManager = (ComponentManager)AdaptTo.notNull((Adaptable)resolver, ComponentManager.class)).getComponentOfResource(componentContent)) != null && component.getEditConfig() != null && component.getEditConfig().getInplaceEditingConfig() != null && StringUtils.isNotEmpty((CharSequence)(ipeConfigPath = component.getEditConfig().getInplaceEditingConfig().getConfigPath()))) {
            return ipeConfigPath + StringUtils.defaultString((String)parser.getRelativeConfigPath());
        }
        return null;
    }

    public static String buildPath(String componentContentPath, Set<String> mediaFormatNames) {
        TreeSet<String> sortedMediaFormatNames = new TreeSet<String>(mediaFormatNames);
        return IPECONFIG_OVERLAY_ROOTPATH + componentContentPath + "/" + "wcmio:mediaFormat" + "/" + StringUtils.join(sortedMediaFormatNames, (String)"/") + "/" + "wcmio:config";
    }
}

