/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl.metadata;

import com.google.common.util.concurrent.Striped;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AssetSynchonizationService.class})
public final class AssetSynchonizationService {
    private static final int STRIPE_COUNT = 100;
    private static final Logger log = LoggerFactory.getLogger(AssetSynchonizationService.class);
    private Striped<Lock> lazyWeakLock;

    @Activate
    private void activate() {
        this.lazyWeakLock = Striped.lazyWeakLock((int)100);
    }

    @Deactivate
    private void deactivate() {
        this.lazyWeakLock = null;
    }

    public Lock getLock(String assetPath) {
        return new LockWithLogging((Lock)this.lazyWeakLock.get((Object)assetPath), assetPath);
    }

    private static final class LockWithLogging
    implements Lock {
        private final Lock delegate;
        private final String assetPath;

        private LockWithLogging(Lock delegate, String assetPath) {
            this.delegate = delegate;
            this.assetPath = assetPath;
        }

        @Override
        public void lock() {
            log.trace("Lock {}", (Object)this.assetPath);
            this.delegate.lock();
        }

        @Override
        public void unlock() {
            log.trace("Unlock {}", (Object)this.assetPath);
            this.delegate.unlock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }
}

