/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.inline;

import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.UriTemplate;
import io.wcm.handler.media.UriTemplateType;
import io.wcm.handler.media.impl.ImageFileServlet;
import io.wcm.handler.media.impl.JcrBinary;
import io.wcm.handler.url.UrlHandler;
import io.wcm.sling.commons.adapter.AdaptTo;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;

class InlineUriTemplate
implements UriTemplate {
    private final String uriTemplate;
    private final UriTemplateType type;
    private final long width;
    private final long height;

    InlineUriTemplate(@NotNull UriTemplateType type, long width, long height, @NotNull Resource resource, @NotNull String fileName, @NotNull MediaArgs mediaArgs, @NotNull Adaptable adaptable) {
        this.uriTemplate = InlineUriTemplate.buildUriTemplate(type, resource, fileName, mediaArgs, adaptable);
        this.type = type;
        this.width = width;
        this.height = height;
    }

    private static String buildUriTemplate(@NotNull UriTemplateType type, @NotNull Resource resource, @NotNull String fileName, @NotNull MediaArgs mediaArgs, @NotNull Adaptable adaptable) {
        String resourcePath = resource.getPath();
        Resource parentResource = resource.getParent();
        if (parentResource != null && JcrBinary.isNtFile(parentResource)) {
            resourcePath = parentResource.getPath();
        }
        long DUMMY_WIDTH = 999991L;
        long DUMMY_HEIGHT = 999992L;
        String path = resourcePath + "." + ImageFileServlet.buildSelectorString(999991L, 999992L, null, null, false) + "." + "file" + "/" + ImageFileServlet.getImageFileName(fileName);
        UrlHandler urlHandler = (UrlHandler)AdaptTo.notNull((Adaptable)adaptable, UrlHandler.class);
        String url = urlHandler.get(path).urlMode(mediaArgs.getUrlMode()).buildExternalResourceUrl(resource);
        switch (type) {
            case CROP_CENTER: {
                url = StringUtils.replace((String)url, (String)Long.toString(999991L), (String)"{width}");
                url = StringUtils.replace((String)url, (String)Long.toString(999992L), (String)"{height}");
                break;
            }
            case SCALE_WIDTH: {
                url = StringUtils.replace((String)url, (String)Long.toString(999991L), (String)"{width}");
                url = StringUtils.replace((String)url, (String)Long.toString(999992L), (String)"0");
                break;
            }
            case SCALE_HEIGHT: {
                url = StringUtils.replace((String)url, (String)Long.toString(999991L), (String)"0");
                url = StringUtils.replace((String)url, (String)Long.toString(999992L), (String)"{height}");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)type));
            }
        }
        return url;
    }

    @Override
    public String getUriTemplate() {
        return this.uriTemplate;
    }

    @Override
    public UriTemplateType getType() {
        return this.type;
    }

    @Override
    public long getMaxWidth() {
        return this.width;
    }

    @Override
    public long getMaxHeight() {
        return this.height;
    }

    public String toString() {
        return this.uriTemplate;
    }
}

