/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.util;

import java.nio.file.Path;
import org.apache.jackrabbit.vault.validation.spi.NodeContext;
import org.jetbrains.annotations.NotNull;

public final class NodeContextImpl
implements NodeContext {
    @NotNull
    private final String nodePath;
    @NotNull
    private final Path filePath;
    @NotNull
    private final Path basePath;

    public NodeContextImpl(@NotNull String nodePath, @NotNull Path filePath, @NotNull Path basePath) {
        this.nodePath = nodePath;
        this.filePath = filePath;
        this.basePath = basePath;
    }

    @Override
    @NotNull
    public String getNodePath() {
        return this.nodePath;
    }

    @Override
    @NotNull
    public Path getFilePath() {
        return this.filePath;
    }

    @Override
    @NotNull
    public Path getBasePath() {
        return this.basePath;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.basePath == null ? 0 : this.basePath.hashCode());
        result = 31 * result + (this.filePath == null ? 0 : this.filePath.hashCode());
        result = 31 * result + (this.nodePath == null ? 0 : this.nodePath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeContextImpl other = (NodeContextImpl)obj;
        if (this.basePath == null ? other.basePath != null : !this.basePath.equals(other.basePath)) {
            return false;
        }
        if (this.filePath == null ? other.filePath != null : !this.filePath.equals(other.filePath)) {
            return false;
        }
        return !(this.nodePath == null ? other.nodePath != null : !this.nodePath.equals(other.nodePath));
    }

    public String toString() {
        return "NodeContextImpl [" + (this.nodePath != null ? "nodePath=" + this.nodePath + ", " : "") + (this.filePath != null ? "filePath=" + this.filePath + ", " : "") + (this.basePath != null ? "basePath=" + this.basePath : "") + "]";
    }
}

