/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.spi2dav;

import java.util.ArrayList;
import java.util.List;
import relocated_for_contentpackage.javax.jcr.RangeIterator;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.javax.jcr.ValueFactory;
import relocated_for_contentpackage.org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.IdFactory;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.QValueFactory;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.QueryInfo;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.QueryResultRow;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import relocated_for_contentpackage.org.apache.jackrabbit.spi2dav.QueryResultRowImpl;
import relocated_for_contentpackage.org.apache.jackrabbit.util.ISO9075;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.MultiStatus;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.MultiStatusResponse;

public class QueryInfoImpl
implements QueryInfo {
    private static final String COLUMNS = "Columns: ";
    private static final String SELECTORS = "Selectors: ";
    private final List<String> columnNames = new ArrayList<String>();
    private final List<String> selectorNames = new ArrayList<String>();
    private final List<QueryResultRow> results = new ArrayList<QueryResultRow>();

    public QueryInfoImpl(MultiStatus ms, IdFactory idFactory, NamePathResolver resolver, ValueFactory valueFactory, QValueFactory qValueFactory) throws RepositoryException {
        String responseDescription = ms.getResponseDescription();
        if (responseDescription == null) {
            throw new RepositoryException("Missing column infos: Unable to build QueryInfo object.");
        }
        if (responseDescription.startsWith(COLUMNS)) {
            for (String line : responseDescription.split("\n")) {
                if (line.startsWith(COLUMNS)) {
                    this.decode(line.substring(COLUMNS.length()), this.columnNames);
                    continue;
                }
                if (!line.startsWith(SELECTORS)) continue;
                this.decode(line.substring(SELECTORS.length()), this.selectorNames);
            }
        } else {
            this.decode(responseDescription, this.columnNames);
        }
        for (MultiStatusResponse response : ms.getResponses()) {
            this.results.add(new QueryResultRowImpl(response, this.getColumnNames(), resolver, qValueFactory, valueFactory, idFactory));
        }
    }

    private void decode(String string, List<String> list) {
        String[] parts = string.split(" ");
        for (int i = 0; i < parts.length; ++i) {
            list.add(ISO9075.decode(parts[i]));
        }
    }

    @Override
    public RangeIterator getRows() {
        return new RangeIteratorAdapter(this.results);
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames.toArray(new String[this.columnNames.size()]);
    }

    @Override
    public String[] getSelectorNames() {
        return this.selectorNames.toArray(new String[this.selectorNames.size()]);
    }
}

