/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.spi2davex;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import relocated_for_contentpackage.javax.jcr.ItemNotFoundException;
import relocated_for_contentpackage.javax.jcr.PropertyType;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.org.apache.http.Header;
import relocated_for_contentpackage.org.apache.http.HttpResponse;
import relocated_for_contentpackage.org.apache.http.client.HttpClient;
import relocated_for_contentpackage.org.apache.http.client.methods.HttpGet;
import relocated_for_contentpackage.org.apache.http.client.methods.HttpHead;
import relocated_for_contentpackage.org.apache.http.client.methods.HttpRequestBase;
import relocated_for_contentpackage.org.apache.http.client.methods.HttpUriRequest;
import relocated_for_contentpackage.org.apache.http.protocol.HttpContext;
import relocated_for_contentpackage.org.apache.jackrabbit.spi2dav.ExceptionConverter;
import relocated_for_contentpackage.org.apache.jackrabbit.spi2dav.ItemResourceConstants;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.DavException;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.MultiStatusResponse;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.client.methods.BaseDavRequest;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.client.methods.HttpPropfind;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.property.DavProperty;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.property.DavPropertySet;

class ValueLoader {
    private final HttpClient client;
    private final HttpContext context;

    ValueLoader(HttpClient client, HttpContext context) {
        this.client = client;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadBinary(String uri, int index, Target target) throws RepositoryException, IOException {
        block4: {
            HttpGet request = new HttpGet(uri);
            try {
                HttpResponse response = this.client.execute((HttpUriRequest)request, this.context);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    target.setStream(response.getEntity().getContent());
                    break block4;
                }
                throw ExceptionConverter.generate(new DavException(statusCode, "Unable to load binary at " + uri + " - Status line = " + response.getStatusLine()));
            }
            finally {
                request.releaseConnection();
            }
        }
    }

    public Map<String, String> loadHeaders(String uri, String[] headerNames) throws IOException, RepositoryException {
        HttpHead request = new HttpHead(uri);
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)request, this.context);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HashMap<String, String> headers = new HashMap<String, String>();
                for (String name : headerNames) {
                    Header hdr = response.getFirstHeader(name);
                    if (hdr == null) continue;
                    headers.put(name, hdr.getValue());
                }
                HashMap<String, String> hashMap = headers;
                return hashMap;
            }
            throw ExceptionConverter.generate(new DavException(statusCode, "Unable to load headers at " + uri + " - Status line = " + response.getStatusLine().toString()));
        }
        finally {
            request.releaseConnection();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int loadType(String uri) throws RepositoryException, IOException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add("type", ItemResourceConstants.NAMESPACE);
        HttpRequestBase request = null;
        try {
            request = new HttpPropfind(uri, nameSet, 0);
            HttpResponse response = this.client.execute((HttpUriRequest)request, this.context);
            ((BaseDavRequest)request).checkSuccess(response);
            MultiStatusResponse[] responses = ((BaseDavRequest)request).getResponseBodyAsMultiStatus(response).getResponses();
            if (responses.length != 1) throw new ItemNotFoundException("Internal error. Cannot retrieve property type at " + uri);
            DavPropertySet props = responses[0].getProperties(200);
            DavProperty<?> type = props.get("type", ItemResourceConstants.NAMESPACE);
            if (type != null) {
                int n = PropertyType.valueFromName(type.getValue().toString());
                return n;
            }
            try {
                throw new RepositoryException("Internal error. Cannot retrieve property type at " + uri);
            }
            catch (DavException e) {
                throw ExceptionConverter.generate(e);
            }
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    static interface Target {
        public void setStream(InputStream var1) throws IOException;

        public void reset();
    }
}

