/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.config;

import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.config.AbstractConfig;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.config.ConfigurationException;

public class VaultSettings
extends AbstractConfig {
    public static final String ELEM_IGNORE = "ignore";
    public static final String ATTR_IGNORE_NAME = "name";
    private Set<String> ignores = new HashSet<String>();

    public Set<String> getIgnoredNames() {
        return this.ignores;
    }

    @Override
    protected void doLoad(Element child) throws ConfigurationException {
        if (!child.getNodeName().equals(ELEM_IGNORE)) {
            throw new ConfigurationException("unexpected element: " + child.getLocalName());
        }
        this.loadIgnore(child);
    }

    public boolean isIgnored(String name) {
        return this.ignores.contains(name);
    }

    private void loadIgnore(Element ignore) {
        String name = ignore.getAttribute(ATTR_IGNORE_NAME);
        if (name != null) {
            this.ignores.add(name);
        }
    }

    @Override
    protected String getRootElemName() {
        return "vault";
    }

    @Override
    protected double getSupportedVersion() {
        return 1.0;
    }

    @Override
    @Deprecated
    protected void doWrite(ContentHandler handler) throws SAXException {
        throw new UnsupportedOperationException("No longer supports write with a SAX contentHandler, user write with XMLStreamWriter instead!");
    }

    @Override
    protected void doWrite(XMLStreamWriter writer) throws XMLStreamException {
        for (String ignore : this.ignores) {
            writer.writeStartElement(ELEM_IGNORE);
            writer.writeAttribute(ATTR_IGNORE_NAME, ignore);
            writer.writeEndElement();
        }
    }

    public static VaultSettings createDefault() {
        VaultSettings s = new VaultSettings();
        s.ignores.add(".svn");
        return s;
    }
}

