/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import relocated_for_contentpackage.javax.jcr.ItemExistsException;
import relocated_for_contentpackage.javax.jcr.Node;
import relocated_for_contentpackage.javax.jcr.NodeIterator;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.javax.jcr.Session;
import relocated_for_contentpackage.org.apache.commons.io.FileUtils;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.config.DefaultMetaInf;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.ArchiveWrapper;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.SubPackageFilterArchive;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.io.Archive;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.io.ImportOptions;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.io.ZipStreamArchive;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.Dependency;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.ExportOptions;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.JcrPackage;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.NoSuchPackageException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.PackageException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.PackageExistsException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.PackageId;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.VaultPackage;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.events.PackageEvent;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.events.impl.PackageEventDispatcher;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.impl.CompositeExportProcessor;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.impl.JcrPackageDefinitionImpl;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.impl.JcrPackageImpl;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.impl.PackageManagerImpl;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.impl.SubPackageExportProcessor;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.impl.ZipVaultPackage;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.impl.AbstractPackageRegistry;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.impl.JcrPackageRegistry;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.impl.JcrRegisteredPackage;

public class JcrPackageManagerImpl
extends PackageManagerImpl
implements JcrPackageManager {
    public static final String ARCHIVE_PACKAGE_ROOT_PATH = "/jcr_root/etc/packages";
    private final JcrPackageRegistry registry;

    @Deprecated
    public JcrPackageManagerImpl(@NotNull Session session, @Nullable String[] roots) {
        this(new JcrPackageRegistry(session, roots));
    }

    public JcrPackageManagerImpl(@NotNull Session session, @Nullable String[] roots, @Nullable String[] authIdsForHookExecution, @Nullable String[] authIdsForRootInstallation, boolean isStrict) {
        this(new JcrPackageRegistry(session, new AbstractPackageRegistry.SecurityConfig(authIdsForHookExecution, authIdsForRootInstallation), isStrict, roots));
    }

    protected JcrPackageManagerImpl(JcrPackageRegistry registry) {
        this.registry = registry;
    }

    private RepositoryException unwrapRepositoryException(Exception e) {
        if (e.getCause() instanceof RepositoryException) {
            return (RepositoryException)e.getCause();
        }
        return new RepositoryException(e);
    }

    public PackageRegistry getRegistry() {
        return this.registry;
    }

    public JcrPackageRegistry getInternalRegistry() {
        return this.registry;
    }

    @Override
    public JcrPackage open(PackageId id) throws RepositoryException {
        try {
            JcrRegisteredPackage pkg = (JcrRegisteredPackage)this.registry.open(id);
            return pkg == null ? null : pkg.getJcrPackage();
        }
        catch (IOException e) {
            throw this.unwrapRepositoryException(e);
        }
    }

    @Override
    public JcrPackage open(Node node) throws RepositoryException {
        return this.registry.open(node, false);
    }

    @Override
    public JcrPackage open(Node node, boolean allowInvalid) throws RepositoryException {
        return this.registry.open(node, allowInvalid);
    }

    @Override
    public PackageId resolve(Dependency dependency, boolean onlyInstalled) throws RepositoryException {
        try {
            return this.registry.resolve(dependency, onlyInstalled);
        }
        catch (IOException e) {
            throw this.unwrapRepositoryException(e);
        }
    }

    @Override
    public PackageId[] usage(PackageId id) throws RepositoryException {
        try {
            return this.registry.usage(id);
        }
        catch (IOException e) {
            throw this.unwrapRepositoryException(e);
        }
    }

    @Override
    public JcrPackage upload(InputStream in, boolean replace) throws RepositoryException, IOException {
        return this.upload(in, replace, false);
    }

    @Override
    public JcrPackage upload(InputStream in, boolean replace, boolean strict) throws RepositoryException, IOException {
        try {
            return this.registry.upload(in, replace);
        }
        catch (PackageExistsException e) {
            throw new ItemExistsException(e.getMessage(), e);
        }
    }

    @Override
    @NotNull
    public PackageId[] extract(@NotNull Archive archive, @NotNull ImportOptions options, boolean replace) throws RepositoryException, PackageException, IOException {
        SubPackageFilterArchive spfArchive = null;
        if (!options.isNonRecursive()) {
            spfArchive = new SubPackageFilterArchive(archive);
            archive = spfArchive;
        } else {
            archive = new ArchiveWrapper(archive);
        }
        ZipVaultPackage pkg = new ZipVaultPackage(archive, true);
        PackageId pid = pkg.getId();
        JcrPackage jcrPack = this.registry.upload(pkg, replace);
        jcrPack = new JcrPackageImpl(this.registry, jcrPack.getNode(), pkg);
        jcrPack.extract(options);
        HashSet<PackageId> ids = new HashSet<PackageId>();
        ids.add(pid);
        if (spfArchive != null) {
            for (Archive.Entry e : spfArchive.getSubPackageEntries()) {
                InputStream in = spfArchive.openInputStream(e);
                if (in == null) continue;
                try (ZipStreamArchive subArchive = new ZipStreamArchive(in);){
                    PackageId[] subIds = this.extract(subArchive, options, replace);
                    ids.addAll(Arrays.asList(subIds));
                }
            }
        }
        pkg.close();
        jcrPack.close();
        return ids.toArray(new PackageId[ids.size()]);
    }

    @Override
    public JcrPackage upload(File file, boolean isTmpFile, boolean replace, String nameHint) throws RepositoryException, IOException {
        return this.upload(file, isTmpFile, replace, nameHint, false);
    }

    @Override
    public JcrPackage upload(File file, boolean isTmpFile, boolean replace, String nameHint, boolean strict) throws RepositoryException, IOException {
        ZipVaultPackage pack = new ZipVaultPackage(file, isTmpFile, strict);
        try {
            return this.registry.upload(pack, replace);
        }
        catch (PackageExistsException e) {
            throw new ItemExistsException(e.getMessage(), e);
        }
    }

    @Override
    public JcrPackage create(Node folder, String name) throws RepositoryException, IOException {
        if (folder == null) {
            folder = this.getPackageRoot();
        }
        return this.registry.createNew(folder, new PackageId(name), null, true);
    }

    @Override
    public JcrPackage create(String group, String name) throws RepositoryException, IOException {
        return this.create(group, name, null);
    }

    @Override
    public JcrPackage create(String group, String name, String version) throws RepositoryException, IOException {
        return this.registry.create(group, name, version);
    }

    @Override
    public void remove(JcrPackage pack) throws RepositoryException {
        try {
            this.registry.remove(pack.getDefinition().getId());
        }
        catch (IOException e) {
            throw this.unwrapRepositoryException(e);
        }
        catch (NoSuchPackageException noSuchPackageException) {
            // empty catch block
        }
    }

    @Override
    public JcrPackage rename(JcrPackage pack, String group, String name) throws PackageException, RepositoryException {
        return this.rename(pack, group, name, null);
    }

    @Override
    public JcrPackage rename(JcrPackage pack, String group, String name, String version) throws PackageException, RepositoryException {
        return this.registry.rename(pack, group, name, version);
    }

    @Override
    public void assemble(JcrPackage pack, ProgressTrackerListener listener) throws PackageException, RepositoryException, IOException {
        pack.verifyId(true, true);
        this.assemble(pack.getNode(), pack.getDefinition(), listener);
    }

    @Override
    public void assemble(Node packNode, JcrPackageDefinition definition, ProgressTrackerListener listener) throws PackageException, RepositoryException, IOException {
        SubPackageExportProcessor sp;
        WorkspaceFilter newFilter;
        Calendar now = Calendar.getInstance();
        JcrPackageDefinitionImpl def = (JcrPackageDefinitionImpl)definition;
        this.validateSubPackages(def);
        def.sealForAssembly(now);
        DefaultMetaInf inf = (DefaultMetaInf)def.getMetaInf();
        CompositeExportProcessor processor = new CompositeExportProcessor();
        if (!this.registry.getPackRootPaths()[0].equals("/etc/packages") && (newFilter = (sp = new SubPackageExportProcessor(this, packNode.getSession())).prepare(inf.getFilter())) != null) {
            inf.setFilter(newFilter);
            processor.addProcessor(sp);
        }
        ExportOptions opts = new ExportOptions();
        opts.setMetaInf(inf);
        opts.setListener(listener);
        processor.addProcessor(def.getInjectProcessor());
        opts.setPostProcessor(processor);
        VaultPackage pack = this.assemble(packNode.getSession(), opts, (File)null);
        PackageId id = pack.getId();
        Node contentNode = packNode.getNode("jcr:content");
        try (FileInputStream in = FileUtils.openInputStream(pack.getFile());){
            contentNode.setProperty("jcr:data", in);
            contentNode.setProperty("jcr:lastModified", now);
            contentNode.setProperty("jcr:mimeType", "application/zip");
            packNode.getSession().save();
        }
        catch (IOException e) {
            throw new PackageException(e);
        }
        pack.close();
        this.dispatch(PackageEvent.Type.ASSEMBLE, id, null);
    }

    private void validateSubPackages(JcrPackageDefinitionImpl def) throws RepositoryException, PackageException {
        List<JcrPackage> subs = this.listPackages(def.getMetaInf().getFilter());
        PackageId id = def.getId();
        for (JcrPackage p : subs) {
            if (p.getDefinition().getId().equals(id)) {
                throw new PackageException("A package cannot include itself. Check filter definition.");
            }
            if (p.isSealed()) continue;
            throw new PackageException("Only sealed (built) sub packages allowed: " + p.getDefinition().getId());
        }
    }

    @Override
    public void assemble(JcrPackageDefinition definition, ProgressTrackerListener listener, OutputStream out) throws IOException, RepositoryException, PackageException {
        JcrPackageDefinitionImpl def = (JcrPackageDefinitionImpl)definition;
        this.validateSubPackages(def);
        Calendar now = Calendar.getInstance();
        def.sealForAssembly(now);
        ExportOptions opts = new ExportOptions();
        opts.setMetaInf(def.getMetaInf());
        opts.setListener(listener);
        opts.setPostProcessor(def.getInjectProcessor());
        this.assemble(def.getNode().getSession(), opts, out);
    }

    @Override
    public void rewrap(JcrPackage pack, ProgressTrackerListener listener) throws PackageException, RepositoryException, IOException {
        FileInputStream in;
        VaultPackage src = ((JcrPackageImpl)pack).getPackage(true);
        Calendar now = Calendar.getInstance();
        pack.verifyId(true, false);
        JcrPackageDefinitionImpl def = (JcrPackageDefinitionImpl)pack.getDefinition();
        def.sealForRewrap(now);
        ExportOptions opts = new ExportOptions();
        opts.setMetaInf(def.getMetaInf());
        opts.setListener(listener);
        opts.setPostProcessor(def.getInjectProcessor());
        VaultPackage dst = this.rewrap(opts, src, (File)null);
        Node packNode = pack.getNode();
        Node contentNode = packNode.getNode("jcr:content");
        try {
            in = FileUtils.openInputStream(dst.getFile());
        }
        catch (IOException e) {
            throw new PackageException(e);
        }
        contentNode.setProperty("jcr:data", in);
        contentNode.setProperty("jcr:lastModified", now);
        contentNode.setProperty("jcr:mimeType", "application/zip");
        packNode.getSession().save();
        dst.close();
    }

    protected Node mkdir(String path, boolean autoSave) throws RepositoryException {
        return this.registry.mkdir(path, autoSave);
    }

    @Override
    public Node getPackageRoot() throws RepositoryException {
        return this.registry.getPrimaryPackageRoot(true);
    }

    @Override
    public Node getPackageRoot(boolean noCreate) throws RepositoryException {
        return this.registry.getPrimaryPackageRoot(!noCreate);
    }

    @Override
    public List<JcrPackage> listPackages() throws RepositoryException {
        return this.listPackages(null);
    }

    @Override
    public List<JcrPackage> listPackages(WorkspaceFilter filter) throws RepositoryException {
        LinkedList<JcrPackage> packages = new LinkedList<JcrPackage>();
        for (Node root : this.registry.getPackageRoots()) {
            this.listPackages(root, packages, filter, false, false);
        }
        Collections.sort(packages);
        return packages;
    }

    @Override
    public List<JcrPackage> listPackages(String group, boolean built) throws RepositoryException {
        LinkedList<JcrPackage> packages = new LinkedList<JcrPackage>();
        for (Node root : this.registry.getPackageRoots()) {
            this.listPackages(root, packages, group, built);
        }
        Collections.sort(packages);
        return packages;
    }

    private void listPackages(Node pkgRoot, List<JcrPackage> packages, String group, boolean built) throws RepositoryException {
        if (group == null || group.length() == 0) {
            this.listPackages(pkgRoot, packages, null, built, false);
        } else {
            if (group.equals(pkgRoot.getPath())) {
                group = "";
            } else if (group.startsWith(pkgRoot.getPath() + "/")) {
                group = group.substring(pkgRoot.getPath().length() + 1);
            }
            if (group.startsWith("/")) {
                return;
            }
            Node root = pkgRoot;
            if (group.length() > 0) {
                if (root.hasNode(group)) {
                    root = root.getNode(group);
                } else {
                    return;
                }
            }
            this.listPackages(root, packages, null, built, true);
        }
    }

    private void listPackages(Node root, List<JcrPackage> packages, WorkspaceFilter filter, boolean built, boolean shallow) throws RepositoryException {
        if (root != null) {
            NodeIterator iter = root.getNodes();
            while (iter.hasNext()) {
                Node child = iter.nextNode();
                if (".snapshot".equals(child.getName())) continue;
                JcrPackageImpl pack = new JcrPackageImpl(this.registry, child);
                try {
                    if (pack.isValid()) {
                        JcrPackageDefinition jDef = pack.getDefinition();
                        if (jDef != null && !jDef.getId().isValid()) {
                            pack.close();
                            continue;
                        }
                        if (!(filter != null && !filter.contains(child.getPath()) || built && pack.getSize() <= 0L)) {
                            packages.add(pack);
                            continue;
                        }
                        pack.close();
                        continue;
                    }
                    if (child.hasNodes() && !shallow) {
                        this.listPackages(child, packages, filter, built, false);
                        continue;
                    }
                    pack.close();
                }
                catch (RepositoryException e) {
                    pack.close();
                    throw e;
                }
            }
        }
    }

    @Override
    public void setDispatcher(@Nullable PackageEventDispatcher dispatcher) {
        super.setDispatcher(dispatcher);
        this.registry.setDispatcher(dispatcher);
    }
}

