/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.mapper;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;

public final class Escape {
    private static final char[] RESERVED_CHARS = new char[]{'<', '>', ':', '\"', '\\', '|', '?', '*', '\u0000'};
    private static final BitSet RESERVED_CHARS_SET = new BitSet();

    private Escape() {
    }

    public static String fileToResourceName(String path) {
        if (path.indexOf(37) >= 0) {
            try {
                return URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("Unsupported encoding.", ex);
            }
        }
        return path;
    }

    public static String resourceToFileName(String path) {
        try {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                if (RESERVED_CHARS_SET.get(c)) {
                    result.append(URLEncoder.encode(String.valueOf(c), StandardCharsets.UTF_8.name()));
                    continue;
                }
                result.append(c);
            }
            return result.toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Unsupported encoding.", ex);
        }
    }

    static {
        for (int i = 0; i < RESERVED_CHARS.length; ++i) {
            RESERVED_CHARS_SET.set(RESERVED_CHARS[i]);
        }
    }
}

