/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.filter;

import java.util.HashSet;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.DumpContext;
import org.apache.jackrabbit.vault.fs.api.ItemFilter;

public class BaseFilter
implements ItemFilter {
    private static final Set<String> validNames = new HashSet<String>();

    @Override
    public boolean matches(Item item, int depth) throws RepositoryException {
        if (item.isNode()) {
            PropertyIterator iter = ((Node)item).getProperties();
            while (iter.hasNext()) {
                String name = iter.nextProperty().getName();
                if (validNames.contains(name)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void dump(DumpContext ctx, boolean isLast) {
        ctx.printf(isLast, "%s:", this.getClass().getSimpleName());
    }

    static {
        validNames.add("jcr:primaryType");
        validNames.add("jcr:mixinTypes");
        validNames.add("jcr:uuid");
        validNames.add("jcr:created");
        validNames.add("jcr:createdBy");
    }
}

