/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt;

import org.apache.sling.ide.transport.RepositoryException;
import org.apache.sling.ide.transport.Result;

public class JcrResult<T>
implements Result<T> {
    private final boolean success;
    private final RepositoryException exception;
    private final T payload;

    public static <T> JcrResult<T> success(T payload) {
        return new JcrResult<T>(true, payload, null);
    }

    public static <T> JcrResult<T> failure(Throwable t) {
        return new JcrResult<Object>(false, null, new RepositoryException(t));
    }

    private JcrResult(boolean success, T payload, RepositoryException exception) {
        this.success = success;
        this.exception = exception;
        this.payload = payload;
    }

    public T get() throws RepositoryException {
        if (this.success) {
            return this.payload;
        }
        throw this.exception;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.getClass().getSimpleName()).append(" [success:").append(this.success);
        if (this.exception != null) {
            out.append(", exception: ").append(this.exception.getClass().getName()).append(" - ").append(this.exception.getMessage());
        }
        out.append(']');
        return out.toString();
    }
}

