/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal.mount;

import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import javax.jcr.version.VersionException;
import org.apache.sling.jcr.base.internal.mount.ProxySession;
import org.apache.sling.jcr.base.internal.mount.ProxyWrapper;

public class ProxyAccessControlManager<T extends AccessControlManager>
extends ProxyWrapper<T>
implements AccessControlManager {
    final T mount;

    public ProxyAccessControlManager(ProxySession<?> mountSession, T delegate, T mount) {
        super(mountSession, delegate);
        this.mount = mount;
    }

    public Privilege[] getSupportedPrivileges(String absPath) throws PathNotFoundException, RepositoryException {
        if (this.mountSession.isMount(absPath)) {
            return this.mount.getSupportedPrivileges(absPath);
        }
        return ((AccessControlManager)this.delegate).getSupportedPrivileges(absPath);
    }

    public Privilege privilegeFromName(String privilegeName) throws AccessControlException, RepositoryException {
        try {
            return ((AccessControlManager)this.delegate).privilegeFromName(privilegeName);
        }
        catch (AccessControlException ex) {
            return this.mount.privilegeFromName(privilegeName);
        }
    }

    public boolean hasPrivileges(String absPath, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
        if (this.mountSession.isMount(absPath)) {
            return this.mount.hasPrivileges(absPath, privileges);
        }
        return ((AccessControlManager)this.delegate).hasPrivileges(absPath, privileges);
    }

    public Privilege[] getPrivileges(String absPath) throws PathNotFoundException, RepositoryException {
        if (this.mountSession.isMount(absPath)) {
            return this.mount.getPrivileges(absPath);
        }
        return ((AccessControlManager)this.delegate).getPrivileges(absPath);
    }

    public AccessControlPolicy[] getPolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        if (this.mountSession.isMount(absPath)) {
            return this.mount.getPolicies(absPath);
        }
        return ((AccessControlManager)this.delegate).getPolicies(absPath);
    }

    public AccessControlPolicy[] getEffectivePolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        if (this.mountSession.isMount(absPath)) {
            return this.mount.getEffectivePolicies(absPath);
        }
        return ((AccessControlManager)this.delegate).getEffectivePolicies(absPath);
    }

    public AccessControlPolicyIterator getApplicablePolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        if (this.mountSession.isMount(absPath)) {
            return this.mount.getApplicablePolicies(absPath);
        }
        return ((AccessControlManager)this.delegate).getApplicablePolicies(absPath);
    }

    public void setPolicy(String absPath, AccessControlPolicy policy) throws PathNotFoundException, AccessControlException, AccessDeniedException, LockException, VersionException, RepositoryException {
        if (this.mountSession.isMountParent(absPath) || this.mountSession.isMount(absPath)) {
            this.mount.setPolicy(absPath, policy);
        }
        if (!this.mountSession.isMount(absPath)) {
            ((AccessControlManager)this.delegate).setPolicy(absPath, policy);
        }
    }

    public void removePolicy(String absPath, AccessControlPolicy policy) throws PathNotFoundException, AccessControlException, AccessDeniedException, LockException, VersionException, RepositoryException {
        if (this.mountSession.isMountParent(absPath) || this.mountSession.isMount(absPath)) {
            this.mount.removePolicy(absPath, policy);
        }
        if (!this.mountSession.isMount(absPath)) {
            ((AccessControlManager)this.delegate).removePolicy(absPath, policy);
        }
    }
}

