/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal.mount;

import java.security.Principal;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.AuthorizableTypeException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.jcr.base.internal.mount.ProxySession;
import org.apache.sling.jcr.base.internal.mount.ProxyWrapper;

public class ProxyUserManager
extends ProxyWrapper<UserManager>
implements UserManager {
    private final UserManager mount;

    public ProxyUserManager(ProxySession<JackrabbitSession> mountSession, UserManager delegate, UserManager mount) {
        super(mountSession, delegate);
        this.mount = mount;
    }

    public Authorizable getAuthorizable(String id) throws RepositoryException {
        return ((UserManager)this.delegate).getAuthorizable(id);
    }

    public <T extends Authorizable> T getAuthorizable(String id, Class<T> authorizableClass) throws AuthorizableTypeException, RepositoryException {
        return (T)((UserManager)this.delegate).getAuthorizable(id, authorizableClass);
    }

    public Authorizable getAuthorizable(Principal principal) throws RepositoryException {
        return ((UserManager)this.delegate).getAuthorizable(principal);
    }

    public Authorizable getAuthorizableByPath(String path) throws UnsupportedRepositoryOperationException, RepositoryException {
        return ((UserManager)this.delegate).getAuthorizableByPath(path);
    }

    public Iterator<Authorizable> findAuthorizables(String relPath, String value) throws RepositoryException {
        return ((UserManager)this.delegate).findAuthorizables(relPath, value);
    }

    public Iterator<Authorizable> findAuthorizables(String relPath, String value, int searchType) throws RepositoryException {
        return ((UserManager)this.delegate).findAuthorizables(relPath, value, searchType);
    }

    public Iterator<Authorizable> findAuthorizables(Query query) throws RepositoryException {
        return ((UserManager)this.delegate).findAuthorizables(query);
    }

    public User createUser(String userID, String password) throws AuthorizableExistsException, RepositoryException {
        User user = ((UserManager)this.delegate).createUser(userID, password);
        this.mount.createUser(userID, password, user.getPrincipal(), user.getPath());
        return user;
    }

    public User createUser(String userID, String password, Principal principal, String intermediatePath) throws AuthorizableExistsException, RepositoryException {
        User user = ((UserManager)this.delegate).createUser(userID, password, principal, intermediatePath);
        this.mount.createUser(userID, password, principal, user.getPath());
        return user;
    }

    public User createSystemUser(String userID, String intermediatePath) throws AuthorizableExistsException, RepositoryException {
        User user = ((UserManager)this.delegate).createSystemUser(userID, intermediatePath);
        this.mount.createSystemUser(userID, user.getPath());
        return user;
    }

    public Group createGroup(String groupID) throws AuthorizableExistsException, RepositoryException {
        Group group = ((UserManager)this.delegate).createGroup(groupID);
        this.mount.createGroup(groupID, group.getPrincipal(), group.getPath());
        return group;
    }

    public Group createGroup(Principal principal) throws AuthorizableExistsException, RepositoryException {
        Group group = ((UserManager)this.delegate).createGroup(principal);
        this.mount.createGroup(group.getID(), principal, group.getPath());
        return group;
    }

    public Group createGroup(Principal principal, String intermediatePath) throws AuthorizableExistsException, RepositoryException {
        Group group = ((UserManager)this.delegate).createGroup(principal, intermediatePath);
        this.mount.createGroup(principal, group.getPath());
        return group;
    }

    public Group createGroup(String groupID, Principal principal, String intermediatePath) throws AuthorizableExistsException, RepositoryException {
        Group group = ((UserManager)this.delegate).createGroup(groupID, principal, intermediatePath);
        this.mount.createGroup(groupID, principal, group.getPath());
        return group;
    }

    public boolean isAutoSave() {
        return ((UserManager)this.delegate).isAutoSave();
    }

    public void autoSave(boolean enable) throws UnsupportedRepositoryOperationException, RepositoryException {
        ((UserManager)this.delegate).autoSave(enable);
        this.mount.autoSave(enable);
    }
}

