/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.sling.jcr.jackrabbit.accessmanager.LocalPrivilege;
import org.apache.sling.jcr.jackrabbit.accessmanager.LocalRestriction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PrivilegesHelper {
    private PrivilegesHelper() {
    }

    private static void toLongestDepth(int parentDepth, Privilege parentPrivilege, Map<Privilege, Integer> privilegeToLongestDepth) {
        Privilege[] declaredAggregatePrivileges;
        for (Privilege privilege : declaredAggregatePrivileges = parentPrivilege.getDeclaredAggregatePrivileges()) {
            Integer oldValue = privilegeToLongestDepth.get(privilege);
            int candidateDepth = parentDepth + 1;
            if (oldValue != null && oldValue >= candidateDepth) continue;
            privilegeToLongestDepth.put(privilege, candidateDepth);
            PrivilegesHelper.toLongestDepth(candidateDepth, privilege, privilegeToLongestDepth);
        }
    }

    public static Map<Privilege, Integer> buildPrivilegeLongestDepthMap(Privilege jcrAll) {
        HashMap<Privilege, Integer> privilegeToLongestPath = new HashMap<Privilege, Integer>();
        privilegeToLongestPath.put(jcrAll, 1);
        PrivilegesHelper.toLongestDepth(1, jcrAll, privilegeToLongestPath);
        return privilegeToLongestPath;
    }

    public static LocalPrivilege localAllowAndDenyPriv(Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, Privilege privilege, boolean allow, @NotNull Set<LocalRestriction> allowRestrictions, boolean deny, @NotNull Set<LocalRestriction> denyRestrictions) {
        LocalPrivilege localPrivilege = privilegeToLocalPrivilegesMap.computeIfAbsent(privilege, LocalPrivilege::new);
        if (allow) {
            localPrivilege.setAllow(true);
            localPrivilege.setAllowRestrictions(allowRestrictions);
        } else {
            localPrivilege.setAllow(false);
            localPrivilege.setAllowRestrictions(Collections.emptySet());
        }
        if (deny) {
            localPrivilege.setDeny(true);
            localPrivilege.setDenyRestrictions(denyRestrictions);
        } else {
            localPrivilege.setDeny(false);
            localPrivilege.setDenyRestrictions(Collections.emptySet());
        }
        if (localPrivilege.isAllow() && localPrivilege.isDeny() && localPrivilege.sameAllowAndDenyRestrictions()) {
            localPrivilege.setDeny(false);
            localPrivilege.setDenyRestrictions(Collections.emptySet());
        }
        return localPrivilege;
    }

    public static LocalPrivilege localAllowPriv(Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, Privilege privilege, boolean isAllow, Set<LocalRestriction> restrictions) {
        LocalPrivilege localPrivilege = privilegeToLocalPrivilegesMap.computeIfAbsent(privilege, LocalPrivilege::new);
        localPrivilege.setAllow(isAllow);
        if (isAllow) {
            localPrivilege.setAllowRestrictions(restrictions);
            if (localPrivilege.isDeny() && localPrivilege.sameAllowAndDenyRestrictions()) {
                localPrivilege.setDeny(false);
                localPrivilege.setDenyRestrictions(Collections.emptySet());
            }
        } else {
            localPrivilege.setAllowRestrictions(Collections.emptySet());
        }
        return localPrivilege;
    }

    public static LocalPrivilege localDenyPriv(Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, Privilege privilege, boolean isDeny, Set<LocalRestriction> restrictions) {
        LocalPrivilege localPrivilege = privilegeToLocalPrivilegesMap.computeIfAbsent(privilege, LocalPrivilege::new);
        localPrivilege.setDeny(isDeny);
        if (isDeny) {
            localPrivilege.setDenyRestrictions(restrictions);
            if (localPrivilege.sameAllowAndDenyRestrictions()) {
                localPrivilege.setAllow(false);
                localPrivilege.setAllowRestrictions(Collections.emptySet());
            }
        } else {
            localPrivilege.setDenyRestrictions(Collections.emptySet());
        }
        return localPrivilege;
    }

    private static void expandAllowAndDenyPrivWithoutAggregates(Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, Privilege p, boolean allow, @NotNull Set<LocalRestriction> allowRestrictions, boolean deny, @NotNull Set<LocalRestriction> denyRestrictions) throws RepositoryException {
        if (p.isAggregate()) {
            Privilege[] aggregatePrivileges;
            for (Privilege aggregatePrivilege : aggregatePrivileges = p.getDeclaredAggregatePrivileges()) {
                if (aggregatePrivilege.isAggregate()) {
                    PrivilegesHelper.expandAllowAndDenyPrivWithoutAggregates(privilegeToLocalPrivilegesMap, aggregatePrivilege, allow, allowRestrictions, deny, denyRestrictions);
                    continue;
                }
                PrivilegesHelper.localAllowAndDenyPriv(privilegeToLocalPrivilegesMap, aggregatePrivilege, allow, allowRestrictions, deny, denyRestrictions);
            }
        } else {
            PrivilegesHelper.localAllowAndDenyPriv(privilegeToLocalPrivilegesMap, p, allow, allowRestrictions, deny, denyRestrictions);
        }
    }

    private static void expandAllowPrivWithoutAggregates(Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, Privilege p, boolean isAllow, Set<LocalRestriction> restrictions) throws RepositoryException {
        if (p.isAggregate()) {
            Privilege[] aggregatePrivileges;
            for (Privilege aggregatePrivilege : aggregatePrivileges = p.getDeclaredAggregatePrivileges()) {
                if (aggregatePrivilege.isAggregate()) {
                    PrivilegesHelper.expandAllowPrivWithoutAggregates(privilegeToLocalPrivilegesMap, aggregatePrivilege, isAllow, restrictions);
                    continue;
                }
                PrivilegesHelper.localAllowPriv(privilegeToLocalPrivilegesMap, aggregatePrivilege, isAllow, restrictions);
            }
        } else {
            PrivilegesHelper.localAllowPriv(privilegeToLocalPrivilegesMap, p, isAllow, restrictions);
        }
    }

    private static void expandDenyPrivWithoutAggregates(Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, Privilege p, boolean isDeny, Set<LocalRestriction> restrictions) throws RepositoryException {
        if (p.isAggregate()) {
            Privilege[] aggregatePrivileges;
            for (Privilege aggregatePrivilege : aggregatePrivileges = p.getDeclaredAggregatePrivileges()) {
                if (aggregatePrivilege.isAggregate()) {
                    PrivilegesHelper.expandDenyPrivWithoutAggregates(privilegeToLocalPrivilegesMap, aggregatePrivilege, isDeny, restrictions);
                    continue;
                }
                PrivilegesHelper.localDenyPriv(privilegeToLocalPrivilegesMap, aggregatePrivilege, isDeny, restrictions);
            }
        } else {
            PrivilegesHelper.localDenyPriv(privilegeToLocalPrivilegesMap, p, isDeny, restrictions);
        }
    }

    public static void allowAndDeny(Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, boolean allow, @NotNull Set<LocalRestriction> allowRestrictions, boolean deny, @NotNull Set<LocalRestriction> denyRestrictions, @NotNull Collection<Privilege> privileges) throws RepositoryException {
        for (Privilege privilege : privileges) {
            PrivilegesHelper.expandAllowAndDenyPrivWithoutAggregates(privilegeToLocalPrivilegesMap, privilege, allow, allowRestrictions, deny, denyRestrictions);
        }
    }

    public static void allow(@NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, @NotNull Set<LocalRestriction> restrictions, @NotNull Collection<Privilege> privileges) throws RepositoryException {
        for (Privilege privilege : privileges) {
            PrivilegesHelper.expandAllowPrivWithoutAggregates(privilegeToLocalPrivilegesMap, privilege, true, restrictions);
        }
    }

    public static void unallow(@NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, @NotNull Collection<Privilege> privileges) throws RepositoryException {
        for (Privilege privilege : privileges) {
            PrivilegesHelper.expandAllowPrivWithoutAggregates(privilegeToLocalPrivilegesMap, privilege, false, Collections.emptySet());
        }
    }

    public static void deny(@NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, @NotNull Set<LocalRestriction> restrictions, @NotNull Collection<Privilege> privileges) throws RepositoryException {
        for (Privilege privilege : privileges) {
            PrivilegesHelper.expandDenyPrivWithoutAggregates(privilegeToLocalPrivilegesMap, privilege, true, restrictions);
        }
    }

    public static void undeny(@NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, @NotNull Collection<Privilege> privileges) throws RepositoryException {
        for (Privilege privilege : privileges) {
            PrivilegesHelper.expandDenyPrivWithoutAggregates(privilegeToLocalPrivilegesMap, privilege, false, Collections.emptySet());
        }
    }

    public static void none(@NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, @NotNull Collection<Privilege> privileges) throws RepositoryException {
        for (Privilege privilege : privileges) {
            PrivilegesHelper.expandAllowPrivWithoutAggregates(privilegeToLocalPrivilegesMap, privilege, false, Collections.emptySet());
            PrivilegesHelper.expandDenyPrivWithoutAggregates(privilegeToLocalPrivilegesMap, privilege, false, Collections.emptySet());
        }
    }

    private static LocalPrivilege localPrivRemoveRestrictions(@NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, @NotNull Privilege privilege, boolean forAllow, boolean forDeny, @NotNull Collection<String> restrictionNames) {
        LocalPrivilege localPrivilege = privilegeToLocalPrivilegesMap.computeIfAbsent(privilege, LocalPrivilege::new);
        forDeny &= localPrivilege.isDeny();
        if (forAllow &= localPrivilege.isAllow()) {
            localPrivilege.unsetAllowRestrictions(restrictionNames);
        }
        if (forDeny) {
            localPrivilege.unsetDenyRestrictions(restrictionNames);
        }
        if (localPrivilege.sameAllowAndDenyRestrictions()) {
            if (forAllow) {
                localPrivilege.setDeny(false);
                localPrivilege.clearDenyRestrictions();
            } else if (forDeny) {
                localPrivilege.setAllow(false);
                localPrivilege.clearAllowRestrictions();
            }
        }
        return localPrivilege;
    }

    private static void removeRestrictionsWithoutAggregates(@NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, @NotNull Privilege p, boolean forAllow, boolean forDeny, @NotNull Collection<String> restrictionNames) throws RepositoryException {
        if (p.isAggregate()) {
            Privilege[] aggregatePrivileges;
            for (Privilege aggregatePrivilege : aggregatePrivileges = p.getDeclaredAggregatePrivileges()) {
                if (aggregatePrivilege.isAggregate()) {
                    PrivilegesHelper.removeRestrictionsWithoutAggregates(privilegeToLocalPrivilegesMap, aggregatePrivilege, forAllow, forDeny, restrictionNames);
                    continue;
                }
                PrivilegesHelper.localPrivRemoveRestrictions(privilegeToLocalPrivilegesMap, aggregatePrivilege, forAllow, forDeny, restrictionNames);
            }
        } else {
            PrivilegesHelper.localPrivRemoveRestrictions(privilegeToLocalPrivilegesMap, p, forAllow, forDeny, restrictionNames);
        }
    }

    private static LocalPrivilege localPrivAddRestriction(@NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, @NotNull Privilege privilege, boolean forAllow, boolean forDeny, @NotNull LocalRestriction restriction, boolean requireAllowOrDenyAlreadySet) {
        LocalPrivilege localPrivilege = privilegeToLocalPrivilegesMap.computeIfAbsent(privilege, LocalPrivilege::new);
        if (forDeny && (!requireAllowOrDenyAlreadySet || localPrivilege.isDeny())) {
            localPrivilege.setDeny(true);
            localPrivilege.unsetDenyRestrictions(Collections.singleton(restriction.getName()));
            localPrivilege.setDenyRestrictions(Collections.singleton(restriction));
        }
        if (forAllow && (!requireAllowOrDenyAlreadySet || localPrivilege.isAllow())) {
            localPrivilege.setAllow(true);
            localPrivilege.unsetAllowRestrictions(Collections.singleton(restriction.getName()));
            localPrivilege.setAllowRestrictions(Collections.singleton(restriction));
        }
        if (localPrivilege.sameAllowAndDenyRestrictions()) {
            if (forAllow) {
                localPrivilege.setDeny(false);
                localPrivilege.setDenyRestrictions(Collections.emptySet());
            } else if (forDeny) {
                localPrivilege.setAllow(false);
                localPrivilege.setAllowRestrictions(Collections.emptySet());
            }
        }
        return localPrivilege;
    }

    private static void addRestrictionWithoutAggregates(Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, Privilege p, boolean forAllow, boolean forDeny, LocalRestriction restriction, boolean requireAllowOrDenyAlreadySet) throws RepositoryException {
        if (p.isAggregate()) {
            Privilege[] aggregatePrivileges;
            for (Privilege aggregatePrivilege : aggregatePrivileges = p.getDeclaredAggregatePrivileges()) {
                if (aggregatePrivilege.isAggregate()) {
                    PrivilegesHelper.addRestrictionWithoutAggregates(privilegeToLocalPrivilegesMap, aggregatePrivilege, forAllow, forDeny, restriction, requireAllowOrDenyAlreadySet);
                    continue;
                }
                PrivilegesHelper.localPrivAddRestriction(privilegeToLocalPrivilegesMap, aggregatePrivilege, forAllow, forDeny, restriction, requireAllowOrDenyAlreadySet);
            }
        } else {
            PrivilegesHelper.localPrivAddRestriction(privilegeToLocalPrivilegesMap, p, forAllow, forDeny, restriction, requireAllowOrDenyAlreadySet);
        }
    }

    public static void allowRestriction(@NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, @NotNull LocalRestriction restriction, @NotNull Collection<Privilege> privileges) throws RepositoryException {
        for (Privilege privilege : privileges) {
            PrivilegesHelper.addRestrictionWithoutAggregates(privilegeToLocalPrivilegesMap, privilege, true, false, restriction, false);
        }
    }

    public static void unallowRestriction(@NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, @NotNull String restrictionName, @NotNull Collection<Privilege> privileges) throws RepositoryException {
        PrivilegesHelper.unallowRestrictions(privilegeToLocalPrivilegesMap, Collections.singleton(restrictionName), privileges);
    }

    public static void unallowRestrictions(@NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, @NotNull Collection<String> restrictionNames, @NotNull Collection<Privilege> privileges) throws RepositoryException {
        for (Privilege privilege : privileges) {
            PrivilegesHelper.removeRestrictionsWithoutAggregates(privilegeToLocalPrivilegesMap, privilege, true, false, restrictionNames);
        }
    }

    public static void denyRestriction(@NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, @NotNull LocalRestriction restriction, @NotNull Collection<Privilege> privileges) throws RepositoryException {
        for (Privilege privilege : privileges) {
            PrivilegesHelper.addRestrictionWithoutAggregates(privilegeToLocalPrivilegesMap, privilege, false, true, restriction, false);
        }
    }

    public static void undenyRestriction(@NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, @NotNull String restrictionName, @NotNull Collection<Privilege> privileges) throws RepositoryException {
        PrivilegesHelper.undenyRestrictions(privilegeToLocalPrivilegesMap, Collections.singleton(restrictionName), privileges);
    }

    public static void undenyRestrictions(@NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, @NotNull Collection<String> restrictionNames, @NotNull Collection<Privilege> privileges) throws RepositoryException {
        for (Privilege privilege : privileges) {
            PrivilegesHelper.removeRestrictionsWithoutAggregates(privilegeToLocalPrivilegesMap, privilege, false, true, restrictionNames);
        }
    }

    public static void allowOrDenyRestriction(@NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, @NotNull LocalRestriction restriction, @NotNull Collection<Privilege> privileges) throws RepositoryException {
        for (Privilege privilege : privileges) {
            PrivilegesHelper.addRestrictionWithoutAggregates(privilegeToLocalPrivilegesMap, privilege, true, true, restriction, true);
        }
    }

    public static void unallowOrUndenyRestriction(@NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, @NotNull String restrictionName, @NotNull Collection<Privilege> privileges) throws RepositoryException {
        PrivilegesHelper.unallowOrUndenyRestrictions(privilegeToLocalPrivilegesMap, Collections.singleton(restrictionName), privileges);
    }

    public static void unallowOrUndenyRestrictions(@NotNull Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, @NotNull Collection<String> restrictionNames, @NotNull Collection<Privilege> privileges) throws RepositoryException {
        for (Privilege privilege : privileges) {
            PrivilegesHelper.removeRestrictionsWithoutAggregates(privilegeToLocalPrivilegesMap, privilege, true, true, restrictionNames);
        }
    }

    @NotNull
    private static Privilege[] getSupportedOrRegisteredPrivileges(@NotNull Session jcrSession, @Nullable String resourcePath) throws RepositoryException {
        Privilege[] supportedPrivileges = null;
        if (resourcePath != null && jcrSession.nodeExists(resourcePath)) {
            supportedPrivileges = jcrSession.getAccessControlManager().getSupportedPrivileges(resourcePath);
        } else {
            Workspace workspace = jcrSession.getWorkspace();
            if (workspace instanceof JackrabbitWorkspace) {
                PrivilegeManager privilegeManager = ((JackrabbitWorkspace)workspace).getPrivilegeManager();
                supportedPrivileges = privilegeManager.getRegisteredPrivileges();
            }
        }
        return supportedPrivileges == null ? new Privilege[]{} : supportedPrivileges;
    }

    public static void consolidateAggregates(Session jcrSession, String resourcePath, Map<Privilege, LocalPrivilege> privilegeToLocalPrivilegesMap, Map<Privilege, Integer> privilegeLongestDepthMap) throws RepositoryException {
        Privilege[] supportedAggregatePrivileges;
        Privilege[] supportedPrivileges = PrivilegesHelper.getSupportedOrRegisteredPrivileges(jcrSession, resourcePath);
        for (Privilege aggregatePrivilege : supportedAggregatePrivileges = (Privilege[])Stream.of(supportedPrivileges).filter(Privilege::isAggregate).sorted((p1, p2) -> ((Integer)privilegeLongestDepthMap.get(p2)).compareTo((Integer)privilegeLongestDepthMap.get(p1))).toArray(Privilege[]::new)) {
            boolean allDeny;
            int childDepth = privilegeLongestDepthMap.getOrDefault(aggregatePrivilege, -1) + 1;
            Privilege[] childPrivileges = (Privilege[])Stream.of(aggregatePrivilege.getDeclaredAggregatePrivileges()).filter(p -> privilegeLongestDepthMap.getOrDefault(p, -1) == childDepth).toArray(Privilege[]::new);
            List childLocalPrivileges = Stream.of(childPrivileges).filter(privilegeToLocalPrivilegesMap::containsKey).map(privilegeToLocalPrivilegesMap::get).collect(Collectors.toList());
            if (childPrivileges.length != childLocalPrivileges.size()) continue;
            boolean allAllow = childLocalPrivileges.stream().allMatch(LocalPrivilege::isAllow);
            if (allAllow) {
                Set<LocalRestriction> firstAllowRestrictions = ((LocalPrivilege)childLocalPrivileges.get(0)).getAllowRestrictions();
                boolean allRestrictionsSame = childLocalPrivileges.stream().allMatch(lp -> firstAllowRestrictions.equals(lp.getAllowRestrictions()));
                if (allRestrictionsSame) {
                    LocalPrivilege alp = privilegeToLocalPrivilegesMap.computeIfAbsent(aggregatePrivilege, LocalPrivilege::new);
                    alp.setAllow(true);
                    alp.setAllowRestrictions(firstAllowRestrictions);
                    for (LocalPrivilege lp2 : childLocalPrivileges) {
                        if (!lp2.sameAllowRestrictions(alp.getAllowRestrictions())) continue;
                        lp2.setAllow(false);
                        lp2.setAllowRestrictions(Collections.emptySet());
                    }
                }
            }
            if (!(allDeny = childLocalPrivileges.stream().allMatch(LocalPrivilege::isDeny))) continue;
            Set<LocalRestriction> firstDenyRestrictions = ((LocalPrivilege)childLocalPrivileges.get(0)).getDenyRestrictions();
            boolean allRestrictionsSame = childLocalPrivileges.stream().allMatch(lp -> firstDenyRestrictions.equals(lp.getDenyRestrictions()));
            if (!allRestrictionsSame) continue;
            LocalPrivilege alp = privilegeToLocalPrivilegesMap.computeIfAbsent(aggregatePrivilege, LocalPrivilege::new);
            alp.setDeny(true);
            alp.setDenyRestrictions(firstDenyRestrictions);
            for (LocalPrivilege lp3 : childLocalPrivileges) {
                if (!lp3.sameDenyRestrictions(alp.getDenyRestrictions())) continue;
                lp3.setDeny(false);
                lp3.setDenyRestrictions(Collections.emptySet());
            }
        }
        privilegeToLocalPrivilegesMap.entrySet().removeIf(entry -> ((LocalPrivilege)entry.getValue()).isNone());
    }
}

