/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jmx.provider.impl;

import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.DeepReadValueMapDecorator;
import org.apache.sling.api.wrappers.ValueMapDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanResource
extends AbstractResource {
    private final String path;
    private final ResourceResolver resourceResolver;
    private final ResourceMetadata metadata = new ResourceMetadata();
    private final MBeanInfo info;
    private final ObjectName objectName;
    private final String resourceType;
    private final MBeanServer mbeanServer;
    private volatile AttributeList attributeList;

    public MBeanResource(MBeanServer mbeanServer, ResourceResolver resolver, String resourceType, String path, MBeanInfo info, ObjectName objectName) {
        this.mbeanServer = mbeanServer;
        this.resourceResolver = resolver;
        this.path = path;
        this.info = info;
        this.objectName = objectName;
        int pos = resourceType.lastIndexOf(58);
        this.resourceType = pos == -1 ? resourceType : resourceType.substring(0, pos);
    }

    public AttributeList getAttributes() {
        if (this.attributeList == null) {
            MBeanAttributeInfo[] infos = this.info.getAttributes();
            String[] names = new String[infos.length];
            int index = 0;
            for (MBeanAttributeInfo i : infos) {
                names[index] = i.getName();
                ++index;
            }
            try {
                this.attributeList = this.mbeanServer.getAttributes(this.objectName, names);
            }
            catch (InstanceNotFoundException e) {
                this.attributeList = new AttributeList();
            }
            catch (ReflectionException e) {
                this.attributeList = new AttributeList();
            }
        }
        return this.attributeList;
    }

    public String getPath() {
        return this.path;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceSuperType() {
        return "sling:mbean";
    }

    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class || type == Map.class) {
            Map<String, Object> propMap = this.getPropertiesMap();
            return (AdapterType)new DeepReadValueMapDecorator((Resource)this, (ValueMap)new ValueMapDecorator(propMap));
        }
        return (AdapterType)super.adaptTo(type);
    }

    private Map<String, Object> getPropertiesMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("sling:resourceType", this.getResourceType());
        result.put("sling:resourceType", this.getResourceSuperType());
        if (this.info.getDescription() != null) {
            result.put("mbean:description", this.info.getDescription());
        }
        result.put("mbean:className", this.info.getClassName());
        result.put("mbean:objectName", this.objectName.getCanonicalName());
        AttributeList values = this.getAttributes();
        for (Attribute a : values) {
            Object value = a.getValue();
            if (value == null) continue;
            result.put(a.getName(), value);
        }
        return result;
    }
}

