/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl.servlet.junit5;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.sling.junit.impl.servlet.junit5.FailureHelper;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class ResultAdapter
extends Result {
    private final transient TestExecutionSummary summary;

    public ResultAdapter(TestExecutionSummary summary) {
        this.summary = summary;
    }

    @Override
    public int getRunCount() {
        return (int)this.summary.getTestsStartedCount();
    }

    @Override
    public int getFailureCount() {
        return (int)this.summary.getTestsFailedCount();
    }

    @Override
    public long getRunTime() {
        return this.summary.getTimeFinished() - this.summary.getTimeStarted();
    }

    @Override
    public List<Failure> getFailures() {
        return this.summary.getFailures().stream().map(FailureHelper::convert).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public int getIgnoreCount() {
        return (int)this.summary.getTestsSkippedCount();
    }

    @Override
    public int getAssumptionFailureCount() {
        return (int)this.summary.getTestsAbortedCount();
    }

    @Override
    public boolean wasSuccessful() {
        return this.summary.getTestsFailedCount() == 0L;
    }

    @Override
    public RunListener createListener() {
        throw new UnsupportedOperationException("createListener is not implemented");
    }
}

