/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.via;

import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.api.wrappers.SlingJakartaHttpServletRequestWrapper;
import org.apache.sling.models.annotations.ViaProviderType;
import org.apache.sling.models.annotations.via.ChildResource;
import org.apache.sling.models.spi.ViaProvider;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ViaProvider.class})
public class ChildResourceViaProvider
implements ViaProvider {
    private static final Logger log = LoggerFactory.getLogger(ChildResourceViaProvider.class);

    public Class<? extends ViaProviderType> getType() {
        return ChildResource.class;
    }

    public Object getAdaptable(Object original, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return ORIGINAL;
        }
        if (original instanceof Resource) {
            Resource resource = (Resource)original;
            return resource.getChild(value);
        }
        if (original instanceof SlingJakartaHttpServletRequest) {
            SlingJakartaHttpServletRequest jakartaRequest = (SlingJakartaHttpServletRequest)original;
            @NotNull Resource resource = jakartaRequest.getResource();
            Resource child = resource.getChild(value);
            if (child == null) {
                log.debug("Could not obtain child {} of resource {}", (Object)value, (Object)resource.getPath());
                return null;
            }
            return new ChildResourceJakartaRequestWrapper(jakartaRequest, child);
        }
        if (original instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest javaxRequest = (SlingHttpServletRequest)original;
            @NotNull Resource resource = javaxRequest.getResource();
            Resource child = resource.getChild(value);
            if (child == null) {
                log.debug("Could not obtain child {} of resource {}", (Object)value, (Object)resource.getPath());
                return null;
            }
            return new ChildResourceRequestWrapper(javaxRequest, child);
        }
        log.warn("Received unexpected adaptable of type {}.", (Object)original.getClass().getName());
        return null;
    }

    private class ChildResourceJakartaRequestWrapper
    extends SlingJakartaHttpServletRequestWrapper {
        private final Resource resource;

        private ChildResourceJakartaRequestWrapper(SlingJakartaHttpServletRequest request, Resource resource) {
            super(request);
            this.resource = resource;
        }

        public Resource getResource() {
            return this.resource;
        }
    }

    @Deprecated(since="2.0.0")
    private class ChildResourceRequestWrapper
    extends SlingHttpServletRequestWrapper {
        private final Resource resource;

        private ChildResourceRequestWrapper(SlingHttpServletRequest request, Resource resource) {
            super(request);
            this.resource = resource;
        }

        public Resource getResource() {
            return this.resource;
        }
    }
}

