/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.jacksonexporter.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sling.models.export.spi.ModelExporter;
import org.apache.sling.models.factory.ExportException;
import org.apache.sling.models.jacksonexporter.ModuleProvider;
import org.apache.sling.models.jacksonexporter.impl.PropertiesUtil;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ModelExporter.class})
@Designate(ocd=Config.class)
public class JacksonExporter
implements ModelExporter {
    private static final Logger log = LoggerFactory.getLogger(JacksonExporter.class);
    private static final String SERIALIZATION_FEATURE_PREFIX = SerializationFeature.class.getSimpleName() + ".";
    private static final int SERIALIZATION_FEATURE_PREFIX_LENGTH = SERIALIZATION_FEATURE_PREFIX.length();
    private static final String MAPPER_FEATURE_PREFIX = MapperFeature.class.getSimpleName() + ".";
    private static final int MAPPER_FEATURE_PREFIX_LENGTH = MAPPER_FEATURE_PREFIX.length();
    @Reference(service=ModuleProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private volatile Collection<ModuleProvider> moduleProviders;
    private Map<String, String> mappingOptions;

    public boolean isSupported(@NotNull Class<?> clazz) {
        return clazz.equals(String.class) || clazz.equals(Map.class);
    }

    public <T> T export(@NotNull Object model, @NotNull Class<T> clazz, @NotNull Map<String, String> options) throws ExportException {
        ObjectMapper mapper = new ObjectMapper();
        Map<String, String> mergedOptions = this.mergeWithConfiguredOptions(options);
        for (Map.Entry<String, String> optionEntry : mergedOptions.entrySet()) {
            SerializationFeature feature;
            String enumName;
            String key = optionEntry.getKey();
            if (key.startsWith(SERIALIZATION_FEATURE_PREFIX)) {
                enumName = key.substring(SERIALIZATION_FEATURE_PREFIX_LENGTH);
                try {
                    feature = SerializationFeature.valueOf((String)enumName);
                    mapper.configure(feature, Boolean.valueOf(optionEntry.getValue()).booleanValue());
                }
                catch (IllegalArgumentException e) {
                    log.warn("Bad SerializationFeature option: {}", (Object)enumName);
                }
                continue;
            }
            if (!key.startsWith(MAPPER_FEATURE_PREFIX)) continue;
            enumName = key.substring(MAPPER_FEATURE_PREFIX_LENGTH);
            try {
                feature = MapperFeature.valueOf((String)enumName);
                mapper.configure((MapperFeature)feature, Boolean.valueOf(optionEntry.getValue()).booleanValue());
            }
            catch (IllegalArgumentException e) {
                log.warn("Bad MapperFeature option: {}", (Object)enumName);
            }
        }
        for (ModuleProvider moduleProvider : this.moduleProviders) {
            mapper.registerModule(moduleProvider.getModule());
        }
        if (clazz.equals(Map.class)) {
            return (T)mapper.convertValue(model, Map.class);
        }
        if (clazz.equals(String.class)) {
            JsonFactory f = new JsonFactory();
            f.setCharacterEscapes((CharacterEscapes)new EscapeCloseScriptBlocks());
            StringWriter writer = new StringWriter();
            boolean printTidy = mergedOptions.containsKey("tidy") ? Boolean.valueOf(mergedOptions.get("tidy")) : false;
            try {
                JsonGenerator jgen = f.createGenerator((Writer)writer);
                if (printTidy) {
                    mapper.writerWithDefaultPrettyPrinter().writeValue(jgen, model);
                } else {
                    mapper.writeValue(jgen, model);
                }
            }
            catch (IOException e) {
                throw new ExportException((Throwable)e);
            }
            return (T)writer.toString();
        }
        return null;
    }

    private Map<String, String> mergeWithConfiguredOptions(@NotNull Map<String, String> options) {
        LinkedHashMap<String, String> mergedMap = new LinkedHashMap<String, String>();
        mergedMap.putAll(this.mappingOptions);
        mergedMap.putAll(options);
        return mergedMap;
    }

    @Activate
    private void activate(Config config) {
        this.mappingOptions = PropertiesUtil.toMap(config.mapping_options());
    }

    @NotNull
    public String getName() {
        return "jackson";
    }

    private static class EscapeCloseScriptBlocks
    extends CharacterEscapes {
        private static final long serialVersionUID = 384022064440034138L;
        private final int[] escapes;

        EscapeCloseScriptBlocks() {
            int[] baseEscapes = EscapeCloseScriptBlocks.standardAsciiEscapesForJSON();
            baseEscapes[60] = -1;
            baseEscapes[62] = -1;
            this.escapes = baseEscapes;
        }

        public int[] getEscapeCodesForAscii() {
            return this.escapes;
        }

        public SerializableString getEscapeSequence(int arg0) {
            return null;
        }
    }

    @ObjectClassDefinition(name="Apache Sling Models Jackson Exporter", description="Configures the Jackson JSON Exporter for Sling Models.")
    static @interface Config {
        @AttributeDefinition(name="Mapping options", description="Mapping options to override default Jackson settings. Mapping options that are passed via request parameters have higher precedence. Example: SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS=true, MapperFeature.SORT_PROPERTIES_ALPHABETICALLY=true")
        public String[] mapping_options();
    }
}

