/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.provisioning.model.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.ModelUtility;
import org.apache.sling.provisioning.model.io.ModelReader;

public class ModelArchiveReader {
    public static Model read(InputStream in, ArtifactConsumer consumer) throws IOException {
        Model model = null;
        JarInputStream jis = new JarInputStream(in);
        Manifest manifest = jis.getManifest();
        if (manifest == null) {
            throw new IOException("Not a model archive - manifest is missing.");
        }
        String version = manifest.getMainAttributes().getValue("Model-Archive-Version");
        if (version == null) {
            throw new IOException("Not a model archive - manifest header is missing.");
        }
        try {
            int number = Integer.valueOf(version);
            if (number < 1 || number > 1) {
                throw new IOException("Not a model archive - invalid manifest header value: " + version);
            }
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Not a model archive - invalid manifest header value: " + version);
        }
        JarEntry entry = null;
        while ((entry = jis.getNextJarEntry()) != null) {
            if ("models/feature.model".equals(entry.getName())) {
                model = ModelUtility.getEffectiveModel(ModelReader.read(new InputStreamReader((InputStream)jis, "UTF-8"), null));
            } else if (!entry.isDirectory() && entry.getName().startsWith("artifacts/")) {
                Artifact artifact = Artifact.fromMvnUrl("mvn:" + entry.getName().substring("artifacts/".length()));
                consumer.consume(artifact, jis);
            }
            jis.closeEntry();
        }
        if (model == null) {
            throw new IOException("Not a model archive - model file is missing.");
        }
        return model;
    }

    public static interface ArtifactConsumer {
        public void consume(Artifact var1, InputStream var2) throws IOException;
    }
}

